/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.cruise.GearCaracteristicsEditorUI;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditGearCaracteristicsAction
extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(EditGearCaracteristicsAction.class);
    protected final PersistenceService persistenceService = this.getContext().getPersistenceService();

    public EditGearCaracteristicsAction(EditCruiseUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        GearCaracteristicsEditorUI editor = ((EditCruiseUI)this.getUI()).getGearCaracteristicsEditor();
        editor.getModel().setEditable(true);
        GearWithOriginalRankOrder gear = (GearWithOriginalRankOrder)EditCruiseUIHandler.GEAR_EDIT_CONTEXT.getContextValue((JAXXContext)this.getUI());
        CaracteristicMap caracteristics = this.persistenceService.getGearCaracteristics(this.getDataContext().getCruise().getId(), gear.getId(), gear.getOriginalRankOrder().shortValue());
        GearWithOriginalRankOrder gearToView = GearWithOriginalRankOrders.newGearWithOriginalRankOrder(gear);
        gearToView.setCaracteristics(caracteristics);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will edit gear " + this.decorate(gearToView) + " with " + gearToView.getCaracteristics().size() + " caracteristics."));
        }
        editor.getModel().setGear(gearToView);
        ((EditCruiseUI)this.getUI()).getMainPanelLayout().setSelected("gearCaracteristics");
    }
}

