/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorScope;

public abstract class AbstractNuitonValidatorProvider
implements NuitonValidatorProvider {
    protected Map<ModelEntry<?>, NuitonValidatorModel<?>> models;
    protected final String name;

    public AbstractNuitonValidatorProvider(String name) {
        this.name = name;
    }

    @Override
    public <O> NuitonValidatorModel<O> getModel(Class<O> type, String context, NuitonValidatorScope ... scopes) {
        ModelEntry<O> key = ModelEntry.createModelEntry(type, context, scopes);
        NuitonValidatorModel<Object> model = this.getModels().get(key);
        if (model == null) {
            model = this.newModel(type, context, scopes);
        }
        return model;
    }

    protected Map<ModelEntry<?>, NuitonValidatorModel<?>> getModels() {
        if (this.models == null) {
            this.models = new HashMap();
        }
        return this.models;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected static class ModelEntry<O>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Class<O> type;
        protected final String context;
        protected final NuitonValidatorScope[] scopes;

        public static <O> ModelEntry<O> createModelEntry(Class<O> type, String context, NuitonValidatorScope ... scopes) {
            return new ModelEntry<O>(type, context, scopes);
        }

        protected ModelEntry(Class<O> type, String context, NuitonValidatorScope ... scopes) {
            this.type = type;
            this.context = context;
            this.scopes = scopes == null ? NuitonValidatorScope.values() : scopes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModelEntry)) {
                return false;
            }
            ModelEntry that = (ModelEntry)o;
            if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
                return false;
            }
            if (!Arrays.equals((Object[])this.scopes, (Object[])that.scopes)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            result = 31 * result + Arrays.hashCode((Object[])this.scopes);
            return result;
        }
    }
}

