/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;

public class ObjectUtil {
    private static Map<Class<?>, Method[]> methodCache = new HashMap();

    public static Object getProperty(Object object, String propertyName) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method[] methodArray = methods = object.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && method.getParameterTypes().length == 0) {
                return method.invoke(object, new Object[0]);
            }
            ++n2;
        }
        throw new RuntimeException("Property not found: " + propertyName);
    }

    public static void setProperty(Object object, String propertyName, String propertyValue) throws IllegalAccessException, InvocationTargetException {
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method[] methods = methodCache.get(object.getClass());
        if (methods == null) {
            methods = object.getClass().getMethods();
            methodCache.put(object.getClass(), methods);
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                Class<?> parameterType = method.getParameterTypes()[0];
                if (method.getParameterTypes().length == 1) {
                    if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
                        method.invoke(object, Boolean.valueOf(propertyValue));
                        return;
                    }
                    if (parameterType.equals(String.class)) {
                        method.invoke(object, propertyValue);
                        return;
                    }
                    if (parameterType.equals(Integer.class)) {
                        method.invoke(object, Integer.valueOf(propertyValue));
                        return;
                    }
                    if (parameterType.equals(Long.class)) {
                        method.invoke(object, Long.valueOf(propertyValue));
                        return;
                    }
                    if (parameterType.equals(BigInteger.class)) {
                        method.invoke(object, new BigInteger(propertyValue));
                        return;
                    }
                    if (parameterType.equals(DatabaseFunction.class)) {
                        method.invoke(object, new DatabaseFunction(propertyValue));
                        return;
                    }
                    if (parameterType.equals(SequenceNextValueFunction.class)) {
                        method.invoke(object, new SequenceNextValueFunction(propertyValue));
                        return;
                    }
                    if (parameterType.equals(SequenceCurrentValueFunction.class)) {
                        method.invoke(object, new SequenceCurrentValueFunction(propertyValue));
                        return;
                    }
                }
            }
            ++n2;
        }
        throw new RuntimeException("Property '" + propertyName + "' not found on object type " + object.getClass().getName());
    }
}

