/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;

abstract class AbstractExpressionCompiler {
    private CompilerEnvirons m_compilerEnv;
    private static final String TOTAL = "Total";
    protected static final String STRING_ROW = "row";
    protected static final String STRING_DATASETROW = "dataSetRow";
    protected String rowIndicator = "row";
    private boolean isDataSetMode = true;
    private IScriptExpression scriptExpr;

    AbstractExpressionCompiler() {
    }

    public void compile(IBaseExpression expr, ScriptContext context) throws DataException {
        if (expr instanceof IScriptExpression) {
            this.compile((IScriptExpression)expr, context);
        } else if (expr instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)expr;
            this.compile(ce.getExpression(), context);
            this.compile(ce.getOperand1(), context);
            this.compile(ce.getOperand2(), context);
        }
    }

    private void compile(IScriptExpression baseExpr, ScriptContext context) throws DataException {
        if (baseExpr == null) {
            return;
        }
        CompiledExpression handle = this.compileExpression(baseExpr, context);
        baseExpr.setHandle(handle);
    }

    protected CompiledExpression compileExpression(IScriptExpression baseExpr, ScriptContext context) throws DataException {
        String exp;
        block3: {
            exp = "";
            try {
                this.scriptExpr = baseExpr;
                exp = baseExpr.getText();
                if (exp != null && !"constant".equals(baseExpr.getScriptId())) break block3;
                return null;
            }
            catch (Exception e) {
                DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, (Object)exp);
                throw dataException;
            }
        }
        IDataScriptEngine engine = (IDataScriptEngine)((Object)context.getScriptEngine("javascript"));
        ScriptOrFnNode tree = this.parse(exp, engine.getJSContext(context));
        return this.processScriptTree(exp, tree, engine.getJSContext(context));
    }

    protected CompiledExpression compileExpression(String expression, ScriptContext context) throws DataException {
        String exp;
        block3: {
            exp = "";
            try {
                exp = expression;
                if (exp != null) break block3;
                return null;
            }
            catch (Exception e) {
                DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, (Object)exp);
                throw dataException;
            }
        }
        IDataScriptEngine engine = (IDataScriptEngine)((Object)context.getScriptEngine("javascript"));
        ScriptOrFnNode tree = this.parse(exp, engine.getJSContext(context));
        return this.processScriptTree(exp, tree, engine.getJSContext(context));
    }

    protected IScriptExpression getScriptExpression() {
        return this.scriptExpr;
    }

    private CompilerEnvirons getCompilerEnv(Context context) {
        if (this.m_compilerEnv == null) {
            this.m_compilerEnv = new CompilerEnvirons();
            this.m_compilerEnv.initFromContext(context);
        }
        return this.m_compilerEnv;
    }

    private CompiledExpression processScriptTree(String expression, ScriptOrFnNode tree, Context context) throws DataException {
        CompiledExpression expr;
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild() == null) {
                throw new DataException("Expression parse error: first child is null. The expression is " + expression, expression);
            }
            if (tree.getFirstChild().getType() != 133 && tree.getFirstChild().getType() != 132 && tree.getFirstChild().getType() != 128) {
                throw new DataException("data.engine.InvalidJSExpr", expression);
            }
            ScriptOrFnNode parent = tree;
            Node exprNode = parent.getFirstChild();
            Node child = exprNode.getFirstChild();
            if (child.getNext() != null) {
                child = exprNode;
            } else {
                parent = exprNode;
            }
            assert (child != null && parent != null);
            expr = this.processChild(context, false, (Node)parent, child, (Node)tree);
        } else {
            expr = this.compileComplexExpr(context, (Node)tree, false);
        }
        if (expr instanceof BytecodeExpression) {
            this.compileForBytecodeExpr(context, tree, expr);
        }
        return expr;
    }

    protected ScriptOrFnNode parse(String expression, Context cx) throws DataException {
        if (expression == null) {
            throw new DataException("data.engine.EmptyExpression");
        }
        CompilerEnvirons compilerEnv = this.getCompilerEnv(cx);
        Parser p = new Parser(compilerEnv, cx.getErrorReporter());
        return p.parse(expression, null, 0);
    }

    protected CompiledExpression processChild(Context context, boolean customerChecked, Node parent, Node child, Node grandFather) throws DataException {
        CompiledExpression compiledExpr = null;
        switch (child.getType()) {
            case 40: {
                compiledExpr = new ConstantExpression(child.getDouble());
                break;
            }
            case 41: {
                compiledExpr = new ConstantExpression(child.getString());
                break;
            }
            case 42: {
                compiledExpr = new ConstantExpression();
                break;
            }
            case 45: {
                compiledExpr = new ConstantExpression(true);
                break;
            }
            case 44: {
                compiledExpr = new ConstantExpression(false);
                break;
            }
            case 33: {
                ConstantExpression ce = AggregationConstantsUtil.getConstantExpression(child);
                if (ce != null) {
                    compiledExpr = ce;
                    break;
                }
            }
            case 36: {
                compiledExpr = this.compileDirectColRefExpr(parent, child, grandFather, customerChecked, context);
                break;
            }
            case 38: {
                compiledExpr = this.compileAggregateExpr(context, parent, child);
            }
        }
        if (compiledExpr == null) {
            compiledExpr = this.compileComplexExpr(context, child, customerChecked);
        }
        return compiledExpr;
    }

    protected abstract CompiledExpression compileDirectColRefExpr(Node var1, Node var2, Node var3, boolean var4, Context var5) throws DataException;

    protected ColumnReferenceExpression compileColRefExpr(Node refNode, boolean customerChecked) throws DataException {
        assert (refNode.getType() == 33 || refNode.getType() == 36);
        Node rowName = refNode.getFirstChild();
        assert (rowName != null);
        if (rowName.getType() != 39) {
            return null;
        }
        String str = rowName.getString();
        assert (str != null);
        if (!str.equals(this.rowIndicator)) {
            return null;
        }
        Node rowColumn = rowName.getNext();
        assert (rowColumn != null);
        if (refNode.getType() == 33 && rowColumn.getType() == 41) {
            return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, rowColumn.getString());
        }
        if (refNode.getType() == 36) {
            if (rowColumn.getType() == 40) {
                return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, (int)rowColumn.getDouble());
            }
            if (rowColumn.getType() == 41) {
                return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, rowColumn.getString());
            }
        }
        return null;
    }

    protected abstract AggregateExpression compileAggregateExpr(Context var1, Node var2, Node var3) throws DataException;

    protected ComplexExpression compileComplexExpr(Context context, Node complexNode, boolean checked) throws DataException {
        ComplexExpression complexExpr = new ComplexExpression();
        Node child = complexNode.getFirstChild();
        complexExpr.addTokenList(complexNode.getType());
        while (child != null) {
            CompiledExpression subExpr;
            Node nextChild = child.getNext();
            if (child.getType() == 40 || child.getType() == 41 || child.getType() == 45 || child.getType() == 44 || child.getType() == 42) {
                subExpr = this.processChild(context, false, complexNode, child, null);
                if (subExpr instanceof ConstantExpression) {
                    complexExpr.addContantsExpressions(subExpr);
                }
                child = nextChild;
                continue;
            }
            subExpr = this.processChild(context, checked, complexNode, child, null);
            complexExpr.addSubExpression(subExpr);
            complexExpr.addTokenList(child.getType());
            child = nextChild;
        }
        this.flattenNestedComplexExprs(complexExpr);
        return complexExpr;
    }

    protected void compileForBytecodeExpr(Context context, ScriptOrFnNode tree, CompiledExpression expr) {
        assert (expr instanceof BytecodeExpression);
        CompilerEnvirons compilerEnv = this.getCompilerEnv(context);
        Interpreter compiler = new Interpreter();
        Object compiledOb = compiler.compile(compilerEnv, tree, null, false);
        Script script = compiler.createScriptObject(compiledOb, null);
        ((BytecodeExpression)expr).setScript(script);
    }

    protected IAggrFunction getAggregationFunction(Node callNode) throws DataException {
        Node firstChild = callNode.getFirstChild();
        if (firstChild.getType() != 33) {
            return null;
        }
        Node getPropLeftChild = firstChild.getFirstChild();
        if (getPropLeftChild.getType() != 39 || !getPropLeftChild.getString().equals(TOTAL)) {
            return null;
        }
        Node getPropRightChild = firstChild.getLastChild();
        if (getPropRightChild.getType() != 41) {
            return null;
        }
        String aggrFuncName = getPropRightChild.getString();
        IAggrFunction agg = AggregationManager.getInstance().getAggregation(aggrFuncName);
        if (agg == null) {
            throw new DataException("data.engine.InvalidTotalFuncName", aggrFuncName);
        }
        return agg;
    }

    private void flattenNestedComplexExprs(ComplexExpression complexExpr) {
        ArrayList<CompiledExpression> interestingSubExpr = new ArrayList<CompiledExpression>();
        ArrayList<CompiledExpression> interestingConstantExpr = new ArrayList<CompiledExpression>();
        ArrayList tokenList = new ArrayList();
        Collection subExprs = complexExpr.getSubExpressions();
        Iterator iter = subExprs.iterator();
        while (iter.hasNext()) {
            CompiledExpression childExpr = (CompiledExpression)iter.next();
            if (childExpr instanceof ColumnReferenceExpression || childExpr instanceof AggregateExpression) {
                interestingSubExpr.add(childExpr);
            } else if (childExpr instanceof ComplexExpression) {
                Collection childSubExprs = ((ComplexExpression)childExpr).getSubExpressions();
                childSubExprs.addAll(((ComplexExpression)childExpr).getConstantExpressions());
                tokenList.addAll(((ComplexExpression)childExpr).getTokenList());
                for (CompiledExpression childChildExpr : childSubExprs) {
                    if (childChildExpr instanceof ColumnReferenceExpression || childChildExpr instanceof AggregateExpression) {
                        interestingSubExpr.add(childChildExpr);
                        continue;
                    }
                    if (childChildExpr instanceof ConstantExpression) {
                        interestingConstantExpr.add(childChildExpr);
                        continue;
                    }
                    assert (false);
                }
            } else assert (false);
            iter.remove();
        }
        complexExpr.addSubExpressions(interestingSubExpr);
        complexExpr.addContantsExpressions(interestingConstantExpr);
        complexExpr.getTokenList().addAll(tokenList);
    }

    public void setDataSetMode(boolean isDataSetMode) {
        this.isDataSetMode = isDataSetMode;
        this.rowIndicator = isDataSetMode ? STRING_ROW : STRING_DATASETROW;
    }

    protected boolean getDataSetMode() {
        return this.isDataSetMode;
    }
}

