/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.simulator.ResultChoiceUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ResultChoiceHandler
extends SimulatorTabHandler {
    private static final Log log = LogFactory.getLog(ResultChoiceHandler.class);
    protected ResultChoiceUI tabUI;
    protected StorageChangeListener resultInfoStorageListener;

    public ResultChoiceHandler(ResultChoiceUI tabUI) {
        super(tabUI);
        this.tabUI = tabUI;
    }

    protected void initListResultNamesModel(StorageChangeEvent evt) {
        List<String> allResults = ResultInfoStorage.getResultInfoNames();
        this.tabUI.listResultNamesModel.setElementList(allResults);
        Collection<String> userResults = this.getParameters().getResultEnabled();
        this.tabUI.listResultNames.clearSelection();
        for (String userResult : userResults) {
            int index = allResults.indexOf(userResult);
            this.tabUI.listResultNames.addSelectionInterval(index, index);
        }
    }

    protected void afterInit() {
        this.resultInfoStorageListener = this::initListResultNamesModel;
        ResultInfoStorage.addStorageListener(this.resultInfoStorageListener);
        this.initListResultNamesModel(null);
    }

    public void refresh() {
        if (this.tabUI.isSensitivity().booleanValue()) {
            this.tabUI.sensitivityOnlyKeepFirstResultCheckBox.setSelected(this.getParameters().isSensitivityAnalysisOnlyKeepFirst());
        } else {
            this.tabUI.resultDeleteAfterExportCheckBox.setSelected(this.getParameters().isResultDeleteAfterExport());
        }
        this.initListResultNamesModel(null);
    }

    protected void saveParametersResultNames(ListSelectionEvent event) {
        ArrayList<String> resultNamesString = new ArrayList<String>(this.tabUI.listResultNames.getSelectedValuesList());
        this.getParameters().setResultEnabled(resultNamesString);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set simulation result names : " + String.valueOf(resultNamesString)));
        }
    }

    protected void saveConfigResultNames() {
        ArrayList<String> resultNamesString = new ArrayList<String>(this.tabUI.listResultNames.getSelectedValuesList());
        IsisFish.config.setDefaultResultNames(resultNamesString);
        this.setStatusMessage(I18n.t((String)"isisfish.resultChoice.saved", (Object[])new Object[0]));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set configuration result names : " + String.valueOf(resultNamesString)));
        }
    }

    protected void setStatusMessage(String txt) {
        WelcomePanelUI root = this.tabUI.getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(txt);
    }
}

