/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.actions;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.InProcessSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;

public class ValidateSimulationAction {
    private static Log log = LogFactory.getLog(ValidateSimulationAction.class);
    private static final SimpleDateFormat df = new SimpleDateFormat("dd-MM-yy-HH:mm:ss.SS");
    protected IsisConfig config = null;
    protected static ResultStorage validatedResultStorage;

    public ValidateSimulationAction(IsisConfig config) {
        this.config = config;
    }

    @ApplicationConfig.Action.Step(value=1)
    public static void validateSimulation(String simulationName) throws Exception {
        SimulationStorage simulation = SimulationStorage.getSimulation(simulationName);
        validatedResultStorage = simulation.getResultStorage();
        ValidateSimulationAction.simulateWithSimulation("Validate-From-" + simulationName + "-" + df.format(new Date()), simulation.createZip());
    }

    @ApplicationConfig.Action.Step(value=1)
    public static void simulateWithSimulation(String simulationId, File simulationZip) throws Exception {
        ValidateSimulationAction.validateWithSimulationAndScript(simulationId, simulationZip, null);
    }

    @ApplicationConfig.Action.Step(value=1)
    public static void validateWithSimulationAndScript(String simulationId, File simulationZip, File simulationPrescript) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Command line action : validateWithSimulationAndScript (" + simulationId + ", " + simulationZip.getAbsolutePath() + ", " + simulationPrescript + ")"));
        }
        String name = simulationId;
        String generatedPrescriptContent = null;
        if (simulationPrescript != null && simulationPrescript.canRead()) {
            generatedPrescriptContent = FileUtils.readFileToString((File)simulationPrescript);
        }
        SimulationControl control = new SimulationControl(name);
        control.setAutoSaveState(true);
        SimulationItem item = new SimulationItem(control, null);
        item.setSimulationZip(simulationZip);
        item.setGeneratedPrescriptContent(generatedPrescriptContent);
        InProcessSimulatorLauncher launcher = new InProcessSimulatorLauncher();
        launcher.simulate(SimulationService.getService(), item);
        SimulationStorage simulation = launcher.getSimulationStorage(SimulationService.getService(), control);
        ValidateSimulationAction.validateResults(simulation.getResultStorage());
        simulation.getStorage().closeContext();
        IsisFish.quit();
    }

    public static void validateResults(ResultStorage newResultStorage) throws Exception {
        if (newResultStorage.getResultName().size() == validatedResultStorage.getResultName().size()) {
            log.info((Object)(I18n.t((String)"isisfish.common.ok", (Object[])new Object[0]) + " nombre de r\u00e9sultats obtenus \u00e9quivalent :" + newResultStorage.getResultName().size() + "/" + validatedResultStorage.getResultName().size()));
        } else {
            log.error((Object)(I18n.t((String)"isisfish.common.ko", (Object[])new Object[0]) + " nombre de r\u00e9sultats obtenus diff\u00e9rent :" + newResultStorage.getResultName().size() + "/" + validatedResultStorage.getResultName().size()));
        }
        List<String> simuNames = validatedResultStorage.getResultName();
        for (String simuName : simuNames) {
            MatrixND validatedMatrix = validatedResultStorage.getMatrix(simuName);
            MatrixND newMatrix = newResultStorage.getMatrix(simuName);
            if (newMatrix == null) {
                log.error((Object)(I18n.t((String)"isisfish.common.ko", (Object[])new Object[0]) + " " + I18n.t((String)"isisfish.error.validation.matrixNotComputed", (Object[])new Object[]{validatedMatrix.getName()})));
                continue;
            }
            if (validatedMatrix.equalsValues(newMatrix)) {
                log.info((Object)(I18n.t((String)"isisfish.common.ok", (Object[])new Object[0]) + " MatrixND:" + validatedMatrix.getName()));
                continue;
            }
            log.error((Object)(I18n.t((String)"isisfish.common.ko", (Object[])new Object[0]) + " MatrixND:" + validatedMatrix.getName()));
        }
    }
}

