/*
 * #%L
 * IsisFish
 * 
 * $Id: MemoryOffsetReader.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/logging/io/MemoryOffsetReader.java $
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin, Benjamin Poussin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.logging.io;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

/**
 * This class is a Offset Reader using a memory cache.
 * 
 * All offsets are saved in memory.
 *
 * @author chemit
 */
public class MemoryOffsetReader extends OffsetReader {

    protected static final Log log = LogFactory.getLog(MemoryOffsetReader.class);

    /** cache of offsets */
    protected Map<Long, Long> offsetCache;

    /** capacity of cache */
    protected int capacity;

    public MemoryOffsetReader(int capacity) {
        super();
        this.capacity = capacity;
        this.offsetCache = new TreeMap<Long, Long>();
    }

    public void close() throws IOException {
        super.close();
        offsetCache.clear();
    }

    public long getOffset(long position) {
        long result = -1;
        if (offsetCache.containsKey(position)) {
            result = offsetCache.get(position);
        }
        return result;
    }

    protected void storeOffset(long position, long offset) {
        if (offsetCache.size() < capacity) {
            offsetCache.put(position, offset);
        } else {
            //TODO throw an exception ?
        }
    }

    protected boolean needCreate() {
        // a memory reader needs always to be recomputed
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(capacity:").append(capacity).append(", nbLines:").append(getNbLines()).append(')');
        return sb.toString();
    }
}
