/*
 * #%L
 * IsisFish
 * 
 * $Id: StrategyInactivityEquation.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/equation/StrategyInactivityEquation.java $
 * %%
 * Copyright (C) 2002 - 2011 Ifremer, Code Lutin, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.util.Args;

/**
 * Strategy's inactivity equation.
 * 
 * @author poussin
 * @version $Revision: 4156 $
 *
 * Last update: $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * by : $Author: echatellier $
 */
public interface StrategyInactivityEquation {

    /**
     * Compute inactivity.
     * 
     * @param context simulation context
     * @param month le mois courant de simulation
     * @param info l'objet associe a la strategie pour le mois courant
     * @return equation result
     * @throws Exception 
     */
    @Args({"context", "month", "info"})
    public double compute(SimulationContext context, Month month, StrategyMonthInfo info) throws Exception;

}
