/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseUserEntityEnum;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.services.service.exportdb.ExportService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.dbeditor.ImportTable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.metadata.TableMeta;

public class ExportTable
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportTable.class);
    protected EchoBaseUserEntityEnum entityType;
    protected String exportFileName;
    protected boolean exportAsSeen;
    protected transient InputStream inputStream;
    protected long contentLength;
    protected String contentType;
    @Inject
    protected transient DbEditorService dbEditorService;
    @Inject
    protected transient ExportService exportService;

    public void setEntityType(EchoBaseUserEntityEnum entityType) {
        this.entityType = entityType;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }

    public void setExportAsSeen(boolean exportAsSeen) {
        this.exportAsSeen = exportAsSeen;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String execute() throws Exception {
        TableMeta table = this.dbEditorService.getTableMeta(this.entityType);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will generate content to export to file: " + this.exportFileName));
        }
        String content = this.exportService.exportData(table, this.exportAsSeen);
        if (log.isDebugEnabled()) {
            log.debug((Object)("file to export " + content));
        }
        byte[] bytes = content.getBytes();
        this.contentLength = bytes.length;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Export content length: " + this.contentLength));
        }
        this.contentType = "text/csv";
        this.inputStream = new ByteArrayInputStream(bytes);
        return "success";
    }
}

