/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grouper<ElementType> {
    private Callback<ElementType> callback;

    public Grouper(Callback<ElementType> callback) {
        this.callback = callback;
    }

    public void group(Collection<ElementType> collection, Comparator<ElementType> comparator) {
        Iterator<ElementType> i = collection.iterator();
        Object last = null;
        while (i.hasNext()) {
            ElementType current = i.next();
            if (last != null && comparator.compare(last, current) == 0) {
                this.callback.addToGroup(current);
            } else {
                this.callback.startGroup(current);
            }
            last = current;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback<ElementType2> {
        public void startGroup(ElementType2 var1);

        public void addToGroup(ElementType2 var1);
    }
}

