/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSortedTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int SORT_NO_ORDER = 0;
    public static final int SORT_ASCENDING_ORDER = 1;
    public static final int SORT_DESCENDING_ORDER = 2;
    public static final int NUM_SORT_DIREECTIONS = 3;
    private AbstractTableModel baseModel;
    private List<Integer> viewToModelMapping;
    private int sortDirection = 1;
    private int sortColumn = 0;
    private ImageIcon upIcon;
    private ImageIcon downIcon;

    public DefaultSortedTableModel(AbstractTableModel model, JTableHeader header) {
        this.baseModel = model;
        model.addTableModelListener(new BaseTableModelListener());
        final JTableHeader baseHeader = header;
        baseHeader.addMouseListener(new HeaderListener());
        final TableCellRenderer baseRenderer = baseHeader.getDefaultRenderer();
        baseHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (baseHeader.getTable().convertColumnIndexToModel(column) == DefaultSortedTableModel.this.sortColumn) {
                    if (DefaultSortedTableModel.this.sortDirection != 0) {
                        label.setHorizontalTextPosition(2);
                        label.setIcon(DefaultSortedTableModel.this.sortDirection == 1 ? DefaultSortedTableModel.this.downIcon : DefaultSortedTableModel.this.upIcon);
                    } else {
                        label.setIcon(null);
                    }
                } else {
                    label.setIcon(null);
                }
                return label;
            }
        });
        this.setupMapping();
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.upIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/up.png"));
        this.downIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/down.png"));
    }

    public TableModel getBaseTableModel() {
        return this.baseModel;
    }

    public int getBaseModelIndex(int viewIndex) {
        return this.viewToModelMapping.get(viewIndex);
    }

    @Override
    public void fireTableCellUpdated(int row, int col) {
        if (this.baseModel != null) {
            this.setupMapping();
        }
        super.fireTableCellUpdated(row, col);
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        if (this.baseModel != null) {
            this.setupMapping();
        }
        super.fireTableChanged(e);
    }

    @Override
    public void fireTableDataChanged() {
        if (this.baseModel != null) {
            this.setupMapping();
        }
        super.fireTableDataChanged();
    }

    @Override
    public void fireTableRowsDeleted(int first, int last) {
        if (this.baseModel != null) {
            this.setupMapping();
        }
        super.fireTableRowsDeleted(first, last);
    }

    @Override
    public void fireTableRowsInserted(int first, int last) {
        if (this.baseModel != null) {
            this.setupMapping();
        }
        super.fireTableRowsInserted(first, last);
    }

    @Override
    public void fireTableRowsUpdated(int first, int last) {
        if (this.baseModel != null) {
            this.setupMapping();
        }
        super.fireTableRowsUpdated(first, last);
    }

    @Override
    public void fireTableStructureChanged() {
        if (this.baseModel != null) {
            this.setupMapping();
        }
        super.fireTableStructureChanged();
    }

    @Override
    public int findColumn(String columnName) {
        if (this.baseModel == null) {
            return -1;
        }
        return this.baseModel.findColumn(columnName);
    }

    @Override
    public int getColumnCount() {
        if (this.baseModel == null) {
            return 0;
        }
        return this.baseModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        if (this.baseModel == null) {
            return 0;
        }
        return this.baseModel.getRowCount();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (this.baseModel == null) {
            return null;
        }
        return this.baseModel.getColumnClass(column);
    }

    @Override
    public String getColumnName(int column) {
        if (this.baseModel == null) {
            return null;
        }
        return this.baseModel.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.baseModel == null) {
            return false;
        }
        return this.baseModel.isCellEditable(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.baseModel == null) {
            return null;
        }
        return this.baseModel.getValueAt(this.viewToModelMapping.get(row), col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.baseModel == null) {
            return;
        }
        this.baseModel.setValueAt(value, this.viewToModelMapping.get(row), col);
        this.fireTableDataChanged();
    }

    private void setupMapping() {
        int numRows = this.baseModel.getRowCount();
        this.viewToModelMapping = new ArrayList<Integer>(numRows);
        for (int i = 0; i < numRows; ++i) {
            this.viewToModelMapping.add(new Integer(i));
        }
        Collections.sort(this.viewToModelMapping, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                if (DefaultSortedTableModel.this.sortDirection == 0 || DefaultSortedTableModel.this.sortColumn == -1) {
                    return a.compareTo(b);
                }
                Comparable first = (Comparable)DefaultSortedTableModel.this.baseModel.getValueAt(a, DefaultSortedTableModel.this.sortColumn);
                Comparable second = (Comparable)DefaultSortedTableModel.this.baseModel.getValueAt(b, DefaultSortedTableModel.this.sortColumn);
                if (DefaultSortedTableModel.this.sortDirection == 1) {
                    return first.compareTo(second);
                }
                return second.compareTo(first);
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((Integer)x0, (Integer)x1);
            }
        });
    }

    private class HeaderListener
    extends MouseAdapter {
        private HeaderListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            int column = header.columnAtPoint(e.getPoint());
            column = header.getTable().convertColumnIndexToModel(column);
            if (column != DefaultSortedTableModel.this.sortColumn) {
                DefaultSortedTableModel.this.sortColumn = column;
                DefaultSortedTableModel.this.sortDirection = 1;
            } else {
                DefaultSortedTableModel.this.sortDirection = (DefaultSortedTableModel.this.sortDirection + 1) % 3;
            }
            super.mouseClicked(e);
            DefaultSortedTableModel.this.fireTableDataChanged();
        }
    }

    private class BaseTableModelListener
    implements TableModelListener {
        private BaseTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            DefaultSortedTableModel.this.fireTableChanged(e);
        }
    }
}

