/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ZipFileIterator {
    private final ZipFile zipFile;
    private final String[] entryNameFilter;
    private final Enumeration<? extends ZipEntry> entries;
    private ZipEntry current;

    ZipFileIterator(ZipFile zipFile, String[] stringArray) throws IOException {
        this.zipFile = zipFile;
        this.entryNameFilter = stringArray;
        this.entries = zipFile.entries();
    }

    public ZipEntry getEntry() {
        return this.current;
    }

    public InputStream next() throws IOException {
        while (this.entries.hasMoreElements()) {
            this.current = this.entries.nextElement();
            if (!this.accept(this.current)) continue;
            return this.zipFile.getInputStream(this.current);
        }
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean accept(ZipEntry zipEntry) {
        if (zipEntry.isDirectory()) {
            return false;
        }
        if (this.entryNameFilter == null) {
            return true;
        }
        for (String string : this.entryNameFilter) {
            if (!zipEntry.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }
}

