/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.generics.io;

import de.huxhorn.sulky.generics.io.Serializer;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableSerializer<E extends Serializable>
implements Serializer<E> {
    private boolean compressing;

    public SerializableSerializer() {
        this(false);
    }

    public SerializableSerializer(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(E object) {
        Object gos;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            if (this.compressing) {
                gos = new GZIPOutputStream(bos);
                oos = new ObjectOutputStream((OutputStream)gos);
            } else {
                oos = new ObjectOutputStream(bos);
            }
            oos.writeObject(object);
            oos.flush();
            oos.close();
            gos = bos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray;
            try {
                e.printStackTrace();
                byArray = null;
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(oos);
                IOUtilities.closeQuietly((OutputStream)bos);
                throw throwable;
            }
            IOUtilities.closeQuietly((OutputStream)oos);
            IOUtilities.closeQuietly((OutputStream)bos);
            return byArray;
        }
        IOUtilities.closeQuietly((OutputStream)oos);
        IOUtilities.closeQuietly((OutputStream)bos);
        return gos;
    }

    public String toString() {
        return "SerializableSerializer[compressing=" + this.compressing + "]";
    }
}

