/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.generics;

import de.huxhorn.sulky.generics.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWrapper<T>
implements Wrapper {
    private T wrapped;

    public GenericWrapper(T wrapped) {
        this.wrapped = wrapped;
    }

    protected T getWrapped() {
        return this.wrapped;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws IllegalArgumentException {
        if (iface.isInstance(this.wrapped)) {
            return iface.cast(this.wrapped);
        }
        if (Wrapper.class.isInstance(this.wrapped) && ((Wrapper)Wrapper.class.cast(this.wrapped)).isWrapperFor(iface)) {
            return ((Wrapper)Wrapper.class.cast(this.wrapped)).unwrap(iface);
        }
        throw new IllegalArgumentException("This Wrapper does not wrap " + iface.getClass() + "!");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        if (iface.isInstance(this.wrapped)) {
            return true;
        }
        return Wrapper.class.isInstance(this.wrapped) && ((Wrapper)Wrapper.class.cast(this.wrapped)).isWrapperFor(iface);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericWrapper that = (GenericWrapper)o;
        return !(this.wrapped == null ? that.wrapped != null : !this.wrapped.equals(that.wrapped));
    }

    public int hashCode() {
        return this.wrapped != null ? this.wrapped.hashCode() : 0;
    }

    public String toString() {
        return "wrapper-" + this.wrapped.getClass().getSimpleName() + "[wrapped=" + this.wrapped + "]";
    }
}

