/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.wordnik.swagger.models.AbstractModel;
import com.wordnik.swagger.models.Xml;
import com.wordnik.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"required", "properties"})
@JsonPropertyOrder(value={"required", "properties"})
public class ModelImpl
extends AbstractModel {
    private String type;
    private String name;
    private List<String> required;
    private Map<String, Property> properties;
    private boolean isSimple = false;
    private String description;
    private Object example;
    private Property additionalProperties;
    private String discriminator;
    private Xml xml;

    public ModelImpl discriminator(String discriminator) {
        this.setDiscriminator(discriminator);
        return this;
    }

    public ModelImpl name(String name) {
        this.setName(name);
        return this;
    }

    public ModelImpl description(String description) {
        this.setDescription(description);
        return this;
    }

    public ModelImpl property(String key, Property property) {
        this.addProperty(key, property);
        return this;
    }

    public ModelImpl example(Object example) {
        this.setExample(example);
        return this;
    }

    public ModelImpl additionalProperties(Property additionalProperties) {
        this.setAdditionalProperties(additionalProperties);
        return this;
    }

    public ModelImpl required(String name) {
        this.addRequired(name);
        return this;
    }

    public ModelImpl xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public Property getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Property additionalProperties) {
        this.setType("object");
        this.additionalProperties = additionalProperties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addRequired(String name) {
        Property p = this.properties.get(name);
        if (p != null) {
            p.setRequired(true);
        }
    }

    public List<String> getRequired() {
        ArrayList<String> output = new ArrayList<String>();
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                Property prop = this.properties.get(key);
                if (prop == null || !prop.getRequired()) continue;
                output.add(key);
            }
        }
        Collections.sort(output);
        if (output.size() > 0) {
            return output;
        }
        return null;
    }

    public void setRequired(List<String> required) {
        this.required = required;
        for (String s : required) {
            Property p;
            if (this.properties == null || (p = this.properties.get(s)) == null) continue;
            p.setRequired(true);
        }
    }

    public void addProperty(String key, Property property) {
        if (property == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        if (this.required != null) {
            for (String ek : this.required) {
                if (!key.equals(ek)) continue;
                property.setRequired(true);
            }
        }
        this.properties.put(key, property);
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Property> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                this.addProperty(key, properties.get(key));
            }
        }
    }

    @Override
    public Object getExample() {
        if (this.example == null) {
            // empty if block
        }
        return this.example;
    }

    @Override
    public void setExample(Object example) {
        this.example = example;
    }

    public Xml getXml() {
        return this.xml;
    }

    public void setXml(Xml xml) {
        this.xml = xml;
    }

    @Override
    public Object clone() {
        ModelImpl cloned = new ModelImpl();
        super.cloneTo(cloned);
        cloned.type = this.type;
        cloned.name = this.name;
        cloned.required = this.required;
        cloned.properties = this.properties;
        cloned.isSimple = this.isSimple;
        cloned.description = this.description;
        cloned.example = this.example;
        cloned.additionalProperties = this.additionalProperties;
        cloned.discriminator = this.discriminator;
        cloned.xml = this.xml;
        return cloned;
    }
}

