/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.HasValue;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;

final class TextFieldValidationSupport
implements Serializable {
    private final HasValue<?, String> field;
    private boolean required;
    private Integer minLength;
    private Integer maxLength;
    private Pattern pattern;

    TextFieldValidationSupport(HasValue<?, String> field) {
        this.field = field;
    }

    void setRequired(boolean required) {
        this.required = required;
    }

    void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    void setPattern(String pattern) {
        this.pattern = pattern == null || pattern.isEmpty() ? null : Pattern.compile(pattern);
    }

    boolean isInvalid(String value) {
        boolean isRequiredButEmpty = this.required && Objects.equals(this.field.getEmptyValue(), value);
        boolean isMaxLengthExceeded = value != null && this.maxLength != null && value.length() > this.maxLength;
        boolean isMinLengthNotReached = value != null && this.minLength != null && value.length() < this.minLength;
        BooleanSupplier doesValueViolatePattern = () -> value != null && this.pattern != null && !this.pattern.matcher(value).matches();
        return isRequiredButEmpty || isMaxLengthExceeded || isMinLengthNotReached || doesValueViolatePattern.getAsBoolean();
    }
}

