/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.InitParameters;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.shared.util.SharedUtil;
import com.vaadin.flow.spring.ForwardingRequestWrapper;
import com.vaadin.flow.spring.SpringVaadinServletService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SpringServlet
extends VaadinServlet {
    protected static final List<String> PROPERTY_NAMES = Arrays.stream(InitParameters.class.getDeclaredFields()).filter(field -> !field.isSynthetic()).map(field -> {
        try {
            return (String)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("unable to access field", e);
        }
    }).collect(Collectors.toList());
    private final ApplicationContext context;
    private final boolean rootMapping;

    public SpringServlet(ApplicationContext context, boolean rootMapping) {
        this.context = context;
        this.rootMapping = rootMapping;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(this.wrapRequest(request), response);
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        SpringVaadinServletService service = new SpringVaadinServletService(this, deploymentConfiguration, this.context);
        service.init();
        return service;
    }

    protected DeploymentConfiguration createDeploymentConfiguration(Properties initParameters) {
        Properties properties = this.config(initParameters);
        return super.createDeploymentConfiguration(properties);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) {
        if (this.rootMapping && request.getPathInfo() == null) {
            return new ForwardingRequestWrapper(request);
        }
        return request;
    }

    private Properties config(Properties initParameters) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)initParameters);
        PROPERTY_NAMES.forEach(property -> this.setProperty((String)property, properties));
        initParameters.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!(key instanceof String)) {
                properties.put(key, value);
            }
        }));
        return properties;
    }

    private void setProperty(String property, Properties properties) {
        this.setProperty("vaadin." + property, property, properties);
    }

    private void setProperty(String envProperty, String initParam, Properties properties) {
        Environment env = (Environment)this.context.getBean(Environment.class);
        String value = env.getProperty(this.upperCaseToDashSeparated(envProperty));
        if (value == null) {
            value = env.getProperty(envProperty);
        }
        if (value != null) {
            properties.put(initParam, value);
        }
    }

    private String upperCaseToDashSeparated(String value) {
        String result = value;
        if (result == null) {
            return null;
        }
        while (!result.equals(result.toLowerCase(Locale.ENGLISH))) {
            result = SharedUtil.camelCaseToDashSeparated((String)result);
        }
        return result;
    }
}

