/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReEncodeEntriesTask
extends Task {
    static final String RE_ENCODE_ENTRIES_TASK_CLASS = "com.unboundid.directory.server.tasks.ReEncodeEntriesTask";
    private static final String ATTR_BACKEND_ID = "ds-task-reencode-backend-id";
    private static final String ATTR_INCLUDE_BRANCH = "ds-task-reencode-include-branch";
    private static final String ATTR_EXCLUDE_BRANCH = "ds-task-reencode-exclude-branch";
    private static final String ATTR_INCLUDE_FILTER = "ds-task-reencode-include-filter";
    private static final String ATTR_EXCLUDE_FILTER = "ds-task-reencode-exclude-filter";
    private static final String ATTR_MAX_ENTRIES_PER_SECOND = "ds-task-reencode-max-entries-per-second";
    private static final String ATTR_SKIP_FULLY_UNCACHED = "ds-task-reencode-skip-fully-uncached-entries";
    private static final String ATTR_SKIP_PARTIALLY_UNCACHED = "ds-task-reencode-skip-partially-uncached-entries";
    private static final String OC_REENCODE_ENTRIES_TASK = "ds-task-reencode";
    static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-reencode-backend-id", TaskMessages.INFO_DISPLAY_NAME_REENCODE_BACKEND_ID.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_BACKEND_ID.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_INCLUDE_BRANCH = new TaskProperty("ds-task-reencode-include-branch", TaskMessages.INFO_DISPLAY_NAME_REENCODE_INCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_INCLUDE_BRANCH.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_EXCLUDE_BRANCH = new TaskProperty("ds-task-reencode-exclude-branch", TaskMessages.INFO_DISPLAY_NAME_REENCODE_EXCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_EXCLUDE_BRANCH.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_INCLUDE_FILTER = new TaskProperty("ds-task-reencode-include-filter", TaskMessages.INFO_DISPLAY_NAME_REENCODE_INCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_INCLUDE_FILTER.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_EXCLUDE_FILTER = new TaskProperty("ds-task-reencode-exclude-filter", TaskMessages.INFO_DISPLAY_NAME_REENCODE_EXCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_EXCLUDE_FILTER.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_MAX_ENTRIES_PER_SECOND = new TaskProperty("ds-task-reencode-max-entries-per-second", TaskMessages.INFO_DISPLAY_NAME_REENCODE_MAX_ENTRIES_PER_SECOND.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_MAX_ENTRIES_PER_SECOND.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_SKIP_FULLY_UNCACHED = new TaskProperty("ds-task-reencode-skip-fully-uncached-entries", TaskMessages.INFO_DISPLAY_NAME_REENCODE_SKIP_FULLY_UNCACHED.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_SKIP_FULLY_UNCACHED.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_SKIP_PARTIALLY_UNCACHED = new TaskProperty("ds-task-reencode-skip-partially-uncached-entries", TaskMessages.INFO_DISPLAY_NAME_REENCODE_SKIP_PARTIALLY_UNCACHED.get(), TaskMessages.INFO_DESCRIPTION_REENCODE_SKIP_PARTIALLY_UNCACHED.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = 1804218099237094046L;
    private final boolean skipFullyUncachedEntries;
    private final boolean skipPartiallyUncachedEntries;
    private final Long maxEntriesPerSecond;
    private final List<String> excludeBranches;
    private final List<String> excludeFilters;
    private final List<String> includeBranches;
    private final List<String> includeFilters;
    private final String backendID;

    public ReEncodeEntriesTask() {
        this.skipFullyUncachedEntries = false;
        this.skipPartiallyUncachedEntries = false;
        this.maxEntriesPerSecond = null;
        this.excludeBranches = null;
        this.excludeFilters = null;
        this.includeBranches = null;
        this.includeFilters = null;
        this.backendID = null;
    }

    public ReEncodeEntriesTask(String taskID, String backendID, List<String> includeBranches, List<String> excludeBranches, List<String> includeFilters, List<String> excludeFilters, Long maxEntriesPerSecond, boolean skipFullyUncachedEntries, boolean skipPartiallyUncachedEntries) {
        this(taskID, backendID, includeBranches, excludeBranches, includeFilters, excludeFilters, maxEntriesPerSecond, skipFullyUncachedEntries, skipPartiallyUncachedEntries, null, null, null, null, null);
    }

    public ReEncodeEntriesTask(String taskID, String backendID, List<String> includeBranches, List<String> excludeBranches, List<String> includeFilters, List<String> excludeFilters, Long maxEntriesPerSecond, boolean skipFullyUncachedEntries, boolean skipPartiallyUncachedEntries, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, backendID, includeBranches, excludeBranches, includeFilters, excludeFilters, maxEntriesPerSecond, skipFullyUncachedEntries, skipPartiallyUncachedEntries, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public ReEncodeEntriesTask(String taskID, String backendID, List<String> includeBranches, List<String> excludeBranches, List<String> includeFilters, List<String> excludeFilters, Long maxEntriesPerSecond, boolean skipFullyUncachedEntries, boolean skipPartiallyUncachedEntries, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) {
        super(taskID, RE_ENCODE_ENTRIES_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(backendID);
        this.backendID = backendID;
        this.maxEntriesPerSecond = maxEntriesPerSecond;
        this.skipFullyUncachedEntries = skipFullyUncachedEntries;
        this.skipPartiallyUncachedEntries = skipPartiallyUncachedEntries;
        this.includeBranches = includeBranches == null || includeBranches.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(includeBranches);
        this.excludeBranches = excludeBranches == null || excludeBranches.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(excludeBranches);
        this.includeFilters = includeFilters == null || includeFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(includeFilters);
        this.excludeFilters = excludeFilters == null || excludeFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(excludeFilters);
    }

    public ReEncodeEntriesTask(Entry entry) throws TaskException {
        super(entry);
        this.backendID = entry.getAttributeValue(ATTR_BACKEND_ID);
        if (this.backendID == null) {
            throw new TaskException(TaskMessages.ERR_REENCODE_TASK_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_BACKEND_ID));
        }
        String[] iBranches = entry.getAttributeValues(ATTR_INCLUDE_BRANCH);
        this.includeBranches = iBranches == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(iBranches));
        String[] eBranches = entry.getAttributeValues(ATTR_EXCLUDE_BRANCH);
        this.excludeBranches = eBranches == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(eBranches));
        String[] iFilters = entry.getAttributeValues(ATTR_INCLUDE_FILTER);
        this.includeFilters = iFilters == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(iFilters));
        String[] eFilters = entry.getAttributeValues(ATTR_EXCLUDE_FILTER);
        this.excludeFilters = eFilters == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(eFilters));
        this.maxEntriesPerSecond = entry.getAttributeValueAsLong(ATTR_MAX_ENTRIES_PER_SECOND);
        Boolean skipFullyUncached = entry.getAttributeValueAsBoolean(ATTR_SKIP_FULLY_UNCACHED);
        this.skipFullyUncachedEntries = skipFullyUncached == null ? false : skipFullyUncached;
        Boolean skipPartiallyUncached = entry.getAttributeValueAsBoolean(ATTR_SKIP_PARTIALLY_UNCACHED);
        this.skipPartiallyUncachedEntries = skipPartiallyUncached == null ? false : skipPartiallyUncached;
    }

    public ReEncodeEntriesTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(RE_ENCODE_ENTRIES_TASK_CLASS, properties);
        boolean skipFullyUncached = false;
        boolean skipPartiallyUncached = false;
        Long maxRate = null;
        List<Object> eBranches = Collections.emptyList();
        List<Object> eFilters = Collections.emptyList();
        List<Object> iBranches = Collections.emptyList();
        List<Object> iFilters = Collections.emptyList();
        String id = null;
        for (Map.Entry<TaskProperty, List<Object>> e : properties.entrySet()) {
            String[] filters;
            String[] branches;
            TaskProperty p = e.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = e.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BACKEND_ID)) {
                id = ReEncodeEntriesTask.parseString(p, values, null);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_BRANCH)) {
                branches = ReEncodeEntriesTask.parseStrings(p, values, null);
                if (branches == null) continue;
                iBranches = Collections.unmodifiableList(Arrays.asList(branches));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_BRANCH)) {
                branches = ReEncodeEntriesTask.parseStrings(p, values, null);
                if (branches == null) continue;
                eBranches = Collections.unmodifiableList(Arrays.asList(branches));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_FILTER)) {
                filters = ReEncodeEntriesTask.parseStrings(p, values, null);
                if (filters == null) continue;
                iFilters = Collections.unmodifiableList(Arrays.asList(filters));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_FILTER)) {
                filters = ReEncodeEntriesTask.parseStrings(p, values, null);
                if (filters == null) continue;
                eFilters = Collections.unmodifiableList(Arrays.asList(filters));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_MAX_ENTRIES_PER_SECOND)) {
                maxRate = ReEncodeEntriesTask.parseLong(p, values, null);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_SKIP_FULLY_UNCACHED)) {
                skipFullyUncached = ReEncodeEntriesTask.parseBoolean(p, values, false);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_SKIP_PARTIALLY_UNCACHED)) continue;
            skipPartiallyUncached = ReEncodeEntriesTask.parseBoolean(p, values, false);
        }
        if (id == null) {
            throw new TaskException(TaskMessages.ERR_REENCODE_TASK_MISSING_REQUIRED_PROPERTY.get(ATTR_BACKEND_ID));
        }
        this.backendID = id;
        this.includeBranches = iBranches;
        this.excludeBranches = eBranches;
        this.includeFilters = iFilters;
        this.excludeFilters = eFilters;
        this.maxEntriesPerSecond = maxRate;
        this.skipFullyUncachedEntries = skipFullyUncached;
        this.skipPartiallyUncachedEntries = skipPartiallyUncached;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_REENCODE_ENTRIES.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_REENCODE_ENTRIES.get();
    }

    public String getBackendID() {
        return this.backendID;
    }

    public List<String> getIncludeBranches() {
        return this.includeBranches;
    }

    public List<String> getExcludeBranches() {
        return this.excludeBranches;
    }

    public List<String> getIncludeFilters() {
        return this.includeFilters;
    }

    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public Long getMaxEntriesPerSecond() {
        return this.maxEntriesPerSecond;
    }

    public boolean skipFullyUncachedEntries() {
        return this.skipFullyUncachedEntries;
    }

    public boolean skipPartiallyUncachedEntries() {
        return this.skipPartiallyUncachedEntries;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_REENCODE_ENTRIES_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(7);
        attrList.add(new Attribute(ATTR_BACKEND_ID, this.backendID));
        attrList.add(new Attribute(ATTR_SKIP_FULLY_UNCACHED, String.valueOf(this.skipFullyUncachedEntries)));
        attrList.add(new Attribute(ATTR_SKIP_PARTIALLY_UNCACHED, String.valueOf(this.skipPartiallyUncachedEntries)));
        if (!this.includeBranches.isEmpty()) {
            attrList.add(new Attribute(ATTR_INCLUDE_BRANCH, this.includeBranches));
        }
        if (!this.excludeBranches.isEmpty()) {
            attrList.add(new Attribute(ATTR_EXCLUDE_BRANCH, this.excludeBranches));
        }
        if (!this.includeFilters.isEmpty()) {
            attrList.add(new Attribute(ATTR_INCLUDE_FILTER, this.includeFilters));
        }
        if (!this.excludeFilters.isEmpty()) {
            attrList.add(new Attribute(ATTR_EXCLUDE_FILTER, this.excludeFilters));
        }
        if (this.maxEntriesPerSecond != null) {
            attrList.add(new Attribute(ATTR_MAX_ENTRIES_PER_SECOND, String.valueOf(this.maxEntriesPerSecond)));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_BACKEND_ID, PROPERTY_INCLUDE_BRANCH, PROPERTY_EXCLUDE_BRANCH, PROPERTY_INCLUDE_FILTER, PROPERTY_EXCLUDE_FILTER, PROPERTY_MAX_ENTRIES_PER_SECOND, PROPERTY_SKIP_FULLY_UNCACHED, PROPERTY_SKIP_PARTIALLY_UNCACHED));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(15);
        props.put(PROPERTY_BACKEND_ID, Collections.singletonList(this.backendID));
        props.put(PROPERTY_INCLUDE_BRANCH, Collections.unmodifiableList(this.includeBranches));
        props.put(PROPERTY_EXCLUDE_BRANCH, Collections.unmodifiableList(this.excludeBranches));
        props.put(PROPERTY_INCLUDE_FILTER, Collections.unmodifiableList(this.includeFilters));
        props.put(PROPERTY_EXCLUDE_FILTER, Collections.unmodifiableList(this.excludeFilters));
        if (this.maxEntriesPerSecond == null) {
            props.put(PROPERTY_MAX_ENTRIES_PER_SECOND, Collections.emptyList());
        } else {
            props.put(PROPERTY_MAX_ENTRIES_PER_SECOND, Collections.singletonList(this.maxEntriesPerSecond));
        }
        props.put(PROPERTY_SKIP_FULLY_UNCACHED, Collections.singletonList(this.skipFullyUncachedEntries));
        props.put(PROPERTY_SKIP_PARTIALLY_UNCACHED, Collections.singletonList(this.skipPartiallyUncachedEntries));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

