/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverPasswordResetTokenExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverPasswordResetTokenExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DeliverPasswordResetToken
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 5793619963770997266L;
    private DNArgument userDN = null;
    private StringArgument compactTextAfterToken = null;
    private StringArgument compactTextBeforeToken = null;
    private StringArgument deliveryMechanism = null;
    private StringArgument fullTextAfterToken = null;
    private StringArgument fullTextBeforeToken = null;
    private StringArgument messageSubject = null;

    public static void main(String ... args) {
        ResultCode resultCode = DeliverPasswordResetToken.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        DeliverPasswordResetToken tool = new DeliverPasswordResetToken(outStream, errStream);
        return tool.runTool(args);
    }

    public DeliverPasswordResetToken(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "deliver-password-reset-token";
    }

    @Override
    public String getToolDescription() {
        return UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "4.0.7";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.userDN = new DNArgument(Character.valueOf('b'), "userDN", true, 1, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_PLACEHOLDER_DN.get(), UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_DESCRIPTION_USER_DN.get());
        this.userDN.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_GROUP_ID.get());
        this.userDN.addLongIdentifier("user-dn", true);
        parser.addArgument(this.userDN);
        this.deliveryMechanism = new StringArgument(Character.valueOf('m'), "deliveryMechanism", false, 0, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_PLACEHOLDER_NAME.get(), UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_DESCRIPTION_MECH.get());
        this.deliveryMechanism.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_GROUP_DELIVERY_MECH.get());
        this.deliveryMechanism.addLongIdentifier("delivery-mechanism", true);
        parser.addArgument(this.deliveryMechanism);
        this.messageSubject = new StringArgument(Character.valueOf('s'), "messageSubject", false, 1, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_PLACEHOLDER_SUBJECT.get(), UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_DESCRIPTION_SUBJECT.get());
        this.messageSubject.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_GROUP_DELIVERY_MECH.get());
        this.messageSubject.addLongIdentifier("message-subject", true);
        parser.addArgument(this.messageSubject);
        this.fullTextBeforeToken = new StringArgument(Character.valueOf('f'), "fullTextBeforeToken", false, 1, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_PLACEHOLDER_FULL_BEFORE.get(), UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_DESCRIPTION_FULL_BEFORE.get());
        this.fullTextBeforeToken.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_GROUP_DELIVERY_MECH.get());
        this.fullTextBeforeToken.addLongIdentifier("full-text-before-token", true);
        parser.addArgument(this.fullTextBeforeToken);
        this.fullTextAfterToken = new StringArgument(Character.valueOf('F'), "fullTextAfterToken", false, 1, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_PLACEHOLDER_FULL_AFTER.get(), UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_DESCRIPTION_FULL_AFTER.get());
        this.fullTextAfterToken.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_GROUP_DELIVERY_MECH.get());
        this.fullTextAfterToken.addLongIdentifier("full-text-after-token", true);
        parser.addArgument(this.fullTextAfterToken);
        this.compactTextBeforeToken = new StringArgument(Character.valueOf('c'), "compactTextBeforeToken", false, 1, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_PLACEHOLDER_COMPACT_BEFORE.get(), UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_DESCRIPTION_COMPACT_BEFORE.get());
        this.compactTextBeforeToken.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_GROUP_DELIVERY_MECH.get());
        this.compactTextBeforeToken.addLongIdentifier("compact-text-before-token", true);
        parser.addArgument(this.compactTextBeforeToken);
        this.compactTextAfterToken = new StringArgument(Character.valueOf('C'), "compactTextAfterToken", false, 1, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_PLACEHOLDER_COMPACT_AFTER.get(), UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_DESCRIPTION_COMPACT_AFTER.get());
        this.compactTextAfterToken.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_GROUP_DELIVERY_MECH.get());
        this.compactTextAfterToken.addLongIdentifier("compact-text-after-token", true);
        parser.addArgument(this.compactTextAfterToken);
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        LDAPConnection conn;
        ArrayList<ObjectPair<String, String>> preferredDeliveryMechanisms;
        if (this.deliveryMechanism.isPresent()) {
            List<String> dmList = this.deliveryMechanism.getValues();
            preferredDeliveryMechanisms = new ArrayList<ObjectPair<String, String>>(dmList.size());
            for (String s : dmList) {
                preferredDeliveryMechanisms.add(new ObjectPair<String, Object>(s, null));
            }
        } else {
            preferredDeliveryMechanisms = null;
        }
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(UnboundIDDSMessages.ERR_DELIVER_PW_RESET_TOKEN_CANNOT_GET_CONNECTION.get(StaticUtils.getExceptionMessage(le)));
            return le.getResultCode();
        }
        try {
            DeliverPasswordResetTokenExtendedResult result;
            DeliverPasswordResetTokenExtendedRequest request = new DeliverPasswordResetTokenExtendedRequest(this.userDN.getStringValue(), this.messageSubject.getValue(), this.fullTextBeforeToken.getValue(), this.fullTextAfterToken.getValue(), this.compactTextBeforeToken.getValue(), this.compactTextAfterToken.getValue(), preferredDeliveryMechanisms, new Control[0]);
            try {
                result = (DeliverPasswordResetTokenExtendedResult)conn.processExtendedOperation(request);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(UnboundIDDSMessages.ERR_DELIVER_PW_RESET_TOKEN_ERROR_PROCESSING_EXTOP.get(StaticUtils.getExceptionMessage(le)));
                ResultCode resultCode = le.getResultCode();
                conn.close();
                return resultCode;
            }
            if (result.getResultCode() == ResultCode.SUCCESS) {
                String mechanism = result.getDeliveryMechanism();
                String id = result.getRecipientID();
                if (id == null) {
                    this.out(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_SUCCESS_RESULT_WITHOUT_ID.get(mechanism));
                } else {
                    this.out(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_SUCCESS_RESULT_WITH_ID.get(mechanism, id));
                }
                String message = result.getDeliveryMessage();
                if (message != null) {
                    this.out(UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_SUCCESS_MESSAGE.get(message));
                }
            } else if (result.getDiagnosticMessage() == null) {
                this.err(UnboundIDDSMessages.ERR_DELIVER_PW_RESET_TOKEN_ERROR_RESULT_NO_MESSAGE.get(String.valueOf(result.getResultCode())));
            } else {
                this.err(UnboundIDDSMessages.ERR_DELIVER_PW_RESET_TOKEN_ERROR_RESULT.get(String.valueOf(result.getResultCode()), result.getDiagnosticMessage()));
            }
            ResultCode resultCode = result.getResultCode();
            return resultCode;
        }
        finally {
            conn.close();
        }
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=password.admin,ou=People,dc=example,dc=com", "--bindPassword", "password", "--userDN", "uid=test.user,ou=People,dc=example,dc=com", "--deliveryMechanism", "SMS", "--deliveryMechanism", "E-Mail", "--messageSubject", "Your password reset token", "--fullTextBeforeToken", "Your single-use password reset token is '", "--fullTextAfterToken", "'.", "--compactTextBeforeToken", "Your single-use password reset token is '", "--compactTextAfterToken", "'."};
        exampleMap.put(args, UnboundIDDSMessages.INFO_DELIVER_PW_RESET_TOKEN_EXAMPLE.get());
        return exampleMap;
    }
}

