/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchingRuleUseDefinition
extends SchemaElement {
    private static final long serialVersionUID = 2366143311976256897L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String matchingRuleUseString;
    private final String oid;
    private final String[] applicableTypes;
    private final String[] names;

    public MatchingRuleUseDefinition(String s) throws LDAPException {
        LinkedHashMap<String, String[]> exts;
        Boolean obsolete;
        String descr;
        ArrayList<String> typeList;
        ArrayList<String> nameList;
        block17: {
            String token;
            Validator.ensureNotNull(s);
            this.matchingRuleUseString = s.trim();
            int length = this.matchingRuleUseString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_EMPTY.get());
            }
            if (this.matchingRuleUseString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_NO_OPENING_PAREN.get(this.matchingRuleUseString));
            }
            int pos = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = MatchingRuleUseDefinition.readOID(this.matchingRuleUseString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(1);
            typeList = new ArrayList<String>(1);
            descr = null;
            obsolete = null;
            exts = new LinkedHashMap<String, String[]>();
            while (true) {
                String lowerToken;
                int tokenStartPos = pos = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, pos, length);
                while (pos < length && this.matchingRuleUseString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.matchingRuleUseString.substring(tokenStartPos, pos);
                if (token.length() > 1 && token.endsWith(")")) {
                    token = token.substring(0, token.length() - 1);
                    --pos;
                }
                if ((lowerToken = StaticUtils.toLowerCase(token)).equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_CLOSE_NOT_AT_END.get(this.matchingRuleUseString));
                    }
                    break block17;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, pos, length);
                        pos = MatchingRuleUseDefinition.readQDStrings(this.matchingRuleUseString, pos, length, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, pos, length);
                        buffer = new StringBuilder();
                        pos = MatchingRuleUseDefinition.readQDString(this.matchingRuleUseString, pos, length, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "OBSOLETE"));
                }
                if (lowerToken.equals("applies")) {
                    if (typeList.isEmpty()) {
                        pos = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, pos, length);
                        pos = MatchingRuleUseDefinition.readOIDs(this.matchingRuleUseString, pos, length, typeList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "APPLIES"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>();
                pos = MatchingRuleUseDefinition.readQDStrings(this.matchingRuleUseString, pos, length, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_DUP_EXT.get(this.matchingRuleUseString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_UNEXPECTED_TOKEN.get(this.matchingRuleUseString, token));
        }
        this.description = descr;
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        if (typeList.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_NO_APPLIES.get(this.matchingRuleUseString));
        }
        this.applicableTypes = new String[typeList.size()];
        typeList.toArray(this.applicableTypes);
        this.isObsolete = obsolete != null;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public MatchingRuleUseDefinition(String oid, String[] names, String description, boolean isObsolete, String[] applicableTypes, Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid, applicableTypes);
        Validator.ensureFalse(applicableTypes.length == 0);
        this.oid = oid;
        this.description = description;
        this.isObsolete = isObsolete;
        this.applicableTypes = applicableTypes;
        this.names = names == null ? StaticUtils.NO_STRINGS : names;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.matchingRuleUseString = buffer.toString();
    }

    private void createDefinitionString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            MatchingRuleUseDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (this.applicableTypes.length == 1) {
            buffer.append(" APPLIES ");
            buffer.append(this.applicableTypes[0]);
        } else if (this.applicableTypes.length > 1) {
            buffer.append(" APPLIES (");
            for (int i = 0; i < this.applicableTypes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $");
                }
                buffer.append(' ');
                buffer.append(this.applicableTypes[i]);
            }
            buffer.append(" )");
        }
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                MatchingRuleUseDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                MatchingRuleUseDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String[] getApplicableAttributeTypes() {
        return this.applicableTypes;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchingRuleUseDefinition)) {
            return false;
        }
        MatchingRuleUseDefinition d = (MatchingRuleUseDefinition)o;
        return this.oid.equals(d.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, d.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.applicableTypes, d.applicableTypes) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, d.description) && this.isObsolete == d.isObsolete && MatchingRuleUseDefinition.extensionsEqual(this.extensions, d.extensions);
    }

    @Override
    public String toString() {
        return this.matchingRuleUseString;
    }
}

