/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.listener.InMemoryDirectoryServerTool;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.Version;
import com.unboundid.ldap.sdk.examples.AuthRate;
import com.unboundid.ldap.sdk.examples.LDAPCompare;
import com.unboundid.ldap.sdk.examples.LDAPDebugger;
import com.unboundid.ldap.sdk.examples.LDAPModify;
import com.unboundid.ldap.sdk.examples.LDAPSearch;
import com.unboundid.ldap.sdk.examples.ModRate;
import com.unboundid.ldap.sdk.examples.SearchAndModRate;
import com.unboundid.ldap.sdk.examples.SearchRate;
import com.unboundid.ldap.sdk.examples.ValidateLDIF;
import com.unboundid.ldap.sdk.persist.GenerateSchemaFromSource;
import com.unboundid.ldap.sdk.persist.GenerateSourceFromSchema;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.OutputStream;
import java.io.PrintStream;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Launcher {
    Launcher() {
    }

    public static void main(String ... args) {
        Launcher.main(System.out, System.err, args);
    }

    public static ResultCode main(OutputStream outStream, OutputStream errStream, String ... args) {
        if (args == null || args.length == 0 || args[0].equalsIgnoreCase("version")) {
            if (outStream != null) {
                PrintStream out = new PrintStream(outStream);
                for (String line : Version.getVersionLines()) {
                    out.println(line);
                }
            }
            return ResultCode.SUCCESS;
        }
        String firstArg = StaticUtils.toLowerCase(args[0]);
        String[] remainingArgs = new String[args.length - 1];
        System.arraycopy(args, 1, remainingArgs, 0, remainingArgs.length);
        if (firstArg.equals("authrate")) {
            return AuthRate.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("in-memory-directory-server")) {
            return InMemoryDirectoryServerTool.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("generate-schema-from-source")) {
            return GenerateSchemaFromSource.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("generate-source-from-schema")) {
            return GenerateSourceFromSchema.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("ldapcompare")) {
            return LDAPCompare.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("ldapmodify")) {
            return LDAPModify.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("ldapsearch")) {
            return LDAPSearch.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("ldap-debugger")) {
            return LDAPDebugger.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("modrate")) {
            return ModRate.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("searchrate")) {
            return SearchRate.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("search-and-mod-rate")) {
            return SearchAndModRate.main(remainingArgs, outStream, errStream);
        }
        if (firstArg.equals("validate-ldif")) {
            return ValidateLDIF.main(remainingArgs, outStream, errStream);
        }
        if (errStream != null) {
            PrintStream err = new PrintStream(errStream);
            err.println("Unrecognized tool name '" + args[0] + '\'');
            err.println("Supported tool names include:");
            err.println("     authrate");
            err.println("     in-memory-directory-server");
            err.println("     generate-schema-from-source");
            err.println("     generate-source-from-schema");
            err.println("     ldapcompare");
            err.println("     ldapmodify");
            err.println("     ldapsearch");
            err.println("     ldap-debugger");
            err.println("     modrate");
            err.println("     searchrate");
            err.println("     search-and-mod-rate");
            err.println("     validate-ldif");
            err.println("     version");
        }
        return ResultCode.PARAM_ERROR;
    }
}

