/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class IntegerArgument
extends Argument {
    private static final long serialVersionUID = 3364985217337213643L;
    private final ArrayList<Integer> values;
    private final int lowerBound;
    private final int upperBound;
    private final List<Integer> defaultValues;

    public IntegerArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, Integer.MIN_VALUE, Integer.MAX_VALUE, (List<Integer>)null);
    }

    public IntegerArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, int lowerBound, int upperBound) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, lowerBound, upperBound, (List<Integer>)null);
    }

    public IntegerArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Integer defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, Integer.MIN_VALUE, Integer.MAX_VALUE, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public IntegerArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, List<Integer> defaultValues) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, Integer.MIN_VALUE, Integer.MAX_VALUE, defaultValues);
    }

    public IntegerArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, int lowerBound, int upperBound, Integer defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, lowerBound, upperBound, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public IntegerArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, int lowerBound, int upperBound, List<Integer> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList();
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public List<Integer> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        int intValue;
        try {
            intValue = Integer.parseInt(valueString);
        }
        catch (Exception e) {
            throw new ArgumentException(ArgsMessages.ERR_INTEGER_VALUE_NOT_INT.get(valueString, this.getIdentifierString()), e);
        }
        if (intValue < this.lowerBound) {
            throw new ArgumentException(ArgsMessages.ERR_INTEGER_VALUE_BELOW_LOWER_BOUND.get(intValue, this.getIdentifierString(), this.lowerBound));
        }
        if (intValue > this.upperBound) {
            throw new ArgumentException(ArgsMessages.ERR_INTEGER_VALUE_ABOVE_UPPER_BOUND.get(intValue, this.getIdentifierString(), this.upperBound));
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        this.values.add(intValue);
    }

    public Integer getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    public List<Integer> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }
}

