/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
class LDIFAttribute
implements Serializable {
    private static final long serialVersionUID = -3771917482408643188L;
    private LinkedHashSet<ASN1OctetString> normalizedValues;
    private final ArrayList<ASN1OctetString> values;
    private final MatchingRule matchingRule;
    private final String name;

    LDIFAttribute(String name, MatchingRule matchingRule, ASN1OctetString value) {
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = new ArrayList(5);
        this.values.add(value);
        this.normalizedValues = null;
    }

    boolean addValue(ASN1OctetString value) throws LDAPException {
        if (this.normalizedValues == null) {
            this.normalizedValues = new LinkedHashSet();
            for (ASN1OctetString s : this.values) {
                this.normalizedValues.add(this.matchingRule.normalize(s));
            }
        }
        if (this.normalizedValues.add(this.matchingRule.normalize(value))) {
            this.values.add(value);
            return true;
        }
        return false;
    }

    Attribute toAttribute() {
        ASN1OctetString[] valueArray = new ASN1OctetString[this.values.size()];
        this.values.toArray(valueArray);
        return new Attribute(this.name, this.matchingRule, valueArray);
    }
}

