/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.metadata.AbstractEntry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFWriter;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.plugins.tiff.HorizontalDifferencingStream;
import com.twelvemonkeys.imageio.plugins.tiff.LZWEncoder;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageWriteParam;
import com.twelvemonkeys.imageio.stream.SubImageOutputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.enc.Encoder;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class TIFFImageWriter
extends ImageWriterBase {
    public static final Rational STANDARD_DPI = new Rational(72L);

    TIFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        long l;
        Object object;
        int[] nArray;
        int[] nArray2;
        this.assertOutput();
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = colorModel.getNumComponents();
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            nArray2 = ((ComponentSampleModel)sampleModel).getBandOffsets();
            nArray = null;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
            nArray2 = null;
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            nArray = null;
            nArray2 = new int[]{0};
        } else {
            throw new IllegalArgumentException("Unknown bit/bandOffsets for sample model: " + sampleModel);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add((Object)new TIFFEntry(256, renderedImage.getWidth()));
        arrayList.add((Object)new TIFFEntry(257, renderedImage.getHeight()));
        arrayList.add((Object)new TIFFEntry(258, this.asShortArray(sampleModel.getSampleSize())));
        if (n > 3) {
            if (colorModel.hasAlpha()) {
                arrayList.add((Object)new TIFFEntry(338, colorModel.isAlphaPremultiplied() ? 1 : 2));
            } else {
                arrayList.add((Object)new TIFFEntry(338, 0));
            }
        }
        int n2 = TIFFImageWriteParam.getCompressionType(imageWriteParam);
        arrayList.add((Object)new TIFFEntry(259, n2));
        switch (n2) {
            case 5: 
            case 8: 
            case 32946: {
                arrayList.add((Object)new TIFFEntry(317, 2));
            }
        }
        int n3 = n2 == 7 ? 6 : this.getPhotometricInterpretation(colorModel);
        arrayList.add((Object)new TIFFEntry(262, n3));
        if (n3 == 3 && colorModel instanceof IndexColorModel) {
            arrayList.add((Object)new TIFFEntry(320, this.createColorMap((IndexColorModel)colorModel)));
            arrayList.add((Object)new TIFFEntry(277, 1));
        } else {
            arrayList.add((Object)new TIFFEntry(277, n));
            object = colorModel.getColorSpace();
            if (object instanceof ICC_ColorSpace && !object.isCS_sRGB()) {
                arrayList.add((Object)new TIFFEntry(34675, ((ICC_ColorSpace)object).getProfile().getData()));
            }
        }
        if (sampleModel.getDataType() == 2) {
            arrayList.add((Object)new TIFFEntry(339, 2));
        }
        arrayList.add((Object)new TIFFEntry(305, "TwelveMonkeys ImageIO TIFF writer"));
        arrayList.add((Object)new TIFFEntry(282, STANDARD_DPI));
        arrayList.add((Object)new TIFFEntry(283, STANDARD_DPI));
        arrayList.add((Object)new TIFFEntry(296, 2));
        arrayList.add((Object)new TIFFEntry(278, Integer.MAX_VALUE));
        object = new TIFFEntry(279, -1);
        arrayList.add(object);
        TIFFEntry tIFFEntry = new TIFFEntry(273, -1);
        arrayList.add((Object)tIFFEntry);
        EXIFWriter eXIFWriter = new EXIFWriter();
        if (n2 == 1) {
            l = eXIFWriter.computeIFDSize(arrayList) + 12L;
            arrayList.remove(object);
            arrayList.add((Object)new TIFFEntry(279, renderedImage.getWidth() * renderedImage.getHeight() * n));
            arrayList.remove((Object)tIFFEntry);
            arrayList.add((Object)new TIFFEntry(273, l));
            eXIFWriter.write(arrayList, this.imageOutput);
            this.imageOutput.flush();
        } else {
            eXIFWriter.writeTIFFHeader(this.imageOutput);
            this.imageOutput.writeInt(-1);
        }
        if (n2 == 7) {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("JPEG");
            if (!iterator.hasNext()) {
                throw new IIOException("No JPEG ImageWriter found!");
            }
            ImageWriter imageWriter = iterator.next();
            try {
                imageWriter.setOutput(new SubImageOutputStream(this.imageOutput));
                imageWriter.write(renderedImage);
            }
            finally {
                imageWriter.dispose();
            }
        } else {
            this.writeImageData(this.createCompressorStream(renderedImage, imageWriteParam), renderedImage, n, nArray2, nArray);
        }
        if (n2 != 1) {
            l = this.imageOutput.getStreamPosition();
            arrayList.remove((Object)tIFFEntry);
            arrayList.add((Object)new TIFFEntry(273, 8));
            arrayList.remove(object);
            arrayList.add((Object)new TIFFEntry(279, l - 8L));
            long l2 = eXIFWriter.writeIFD(arrayList, this.imageOutput);
            this.imageOutput.writeInt(0);
            l = this.imageOutput.getStreamPosition();
            this.imageOutput.seek(4L);
            this.imageOutput.writeInt((int)l2);
            this.imageOutput.seek(l);
            this.imageOutput.flush();
        }
    }

    private DataOutput createCompressorStream(RenderedImage renderedImage, ImageWriteParam imageWriteParam) {
        int n = TIFFImageWriteParam.getCompressionType(imageWriteParam);
        switch (n) {
            case 1: {
                return this.imageOutput;
            }
            case 32773: {
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new EncoderStream(outputStream, (Encoder)new PackBitsEncoder(), true);
                return new DataOutputStream(outputStream);
            }
            case 8: 
            case 32946: {
                int n2 = 1;
                if (imageWriteParam.getCompressionMode() == 2) {
                    n2 = 9 - Math.round(8.0f * imageWriteParam.getCompressionQuality());
                }
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new DeflaterOutputStream(outputStream, new Deflater(n2), 1024);
                outputStream = new HorizontalDifferencingStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTile(0, 0).getNumBands(), renderedImage.getColorModel().getComponentSize(0), this.imageOutput.getByteOrder());
                return new DataOutputStream(outputStream);
            }
            case 5: {
                OutputStream outputStream = IIOUtil.createStreamAdapter((ImageOutputStream)this.imageOutput);
                outputStream = new EncoderStream(outputStream, (Encoder)new LZWEncoder((renderedImage.getTileWidth() * renderedImage.getTileHeight() * renderedImage.getTile(0, 0).getNumBands() * renderedImage.getColorModel().getComponentSize(0) + 7) / 8));
                outputStream = new HorizontalDifferencingStream(outputStream, renderedImage.getTileWidth(), renderedImage.getTile(0, 0).getNumBands(), renderedImage.getColorModel().getComponentSize(0), this.imageOutput.getByteOrder());
                return new DataOutputStream(outputStream);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported TIFF compression: %d", n));
    }

    private int getPhotometricInterpretation(ColorModel colorModel) {
        if (colorModel.getNumComponents() == 1 && colorModel.getComponentSize(0) == 1) {
            if (colorModel instanceof IndexColorModel) {
                if (colorModel.getRGB(0) == 0xFFFFFF && colorModel.getRGB(1) == 0) {
                    return 0;
                }
                if (colorModel.getRGB(0) != 0 || colorModel.getRGB(1) != 0xFFFFFF) {
                    return 3;
                }
            }
            return 1;
        }
        if (colorModel instanceof IndexColorModel) {
            return 3;
        }
        switch (colorModel.getColorSpace().getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 9: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Can't determine PhotometricInterpretation for color model: " + colorModel);
    }

    private short[] createColorMap(IndexColorModel indexColorModel) {
        short[] sArray = new short[(int)(3.0 * Math.pow(2.0, indexColorModel.getPixelSize()))];
        for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
            int n = indexColorModel.getRGB(i);
            sArray[i] = (short)this.upScale(n >> 16 & 0xFF);
            sArray[i + sArray.length / 3] = (short)this.upScale(n >> 8 & 0xFF);
            sArray[i + 2 * sArray.length / 3] = (short)this.upScale(n & 0xFF);
        }
        return sArray;
    }

    private int upScale(int n) {
        return 257 * n;
    }

    private short[] asShortArray(int[] nArray) {
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)nArray[i];
        }
        return sArray;
    }

    private void writeImageData(DataOutput dataOutput, RenderedImage renderedImage, int n, int[] nArray, int[] nArray2) throws IOException {
        this.processImageStarted(0);
        int n2 = renderedImage.getMinTileY();
        int n3 = n2 + renderedImage.getNumYTiles();
        int n4 = renderedImage.getMinTileX();
        int n5 = n4 + renderedImage.getNumXTiles();
        int n6 = renderedImage.getTileHeight();
        int n7 = renderedImage.getTileWidth();
        int n8 = renderedImage.getSampleModel().getSampleSize(0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n7 * renderedImage.getSampleModel().getNumBands() * n8 / 8);
        for (int i = n2; i < n3; ++i) {
            block6: for (int j = n4; j < n5; ++j) {
                Raster raster = renderedImage.getTile(j, i);
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n9 = raster.getNumBands();
                switch (dataBuffer.getDataType()) {
                    case 0: {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        for (n14 = 0; n14 < dataBuffer.getNumBanks(); ++n14) {
                            for (n13 = 0; n13 < n6; ++n13) {
                                n12 = n13 * n7 * n9;
                                for (int k = 0; k < n7; ++k) {
                                    n11 = n12 + k * n9;
                                    for (n10 = 0; n10 < n9; ++n10) {
                                        byteBuffer.put((byte)(dataBuffer.getElem(n14, n11 + nArray[n10]) & 0xFF));
                                    }
                                }
                                this.flushBuffer(byteBuffer, dataOutput);
                                if (!(dataOutput instanceof DataOutputStream)) continue;
                                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                dataOutputStream.flush();
                            }
                        }
                        continue block6;
                    }
                    case 1: 
                    case 2: {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        if (n == 1) {
                            for (n14 = 0; n14 < dataBuffer.getNumBanks(); ++n14) {
                                for (n13 = 0; n13 < n6; ++n13) {
                                    n12 = n13 * n7;
                                    for (int k = 0; k < n7; ++k) {
                                        n11 = n12 + k;
                                        byteBuffer.putShort((short)(dataBuffer.getElem(n14, n11) & 0xFFFF));
                                    }
                                    this.flushBuffer(byteBuffer, dataOutput);
                                    if (!(dataOutput instanceof DataOutputStream)) continue;
                                    DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                    dataOutputStream.flush();
                                }
                            }
                            continue block6;
                        }
                        throw new IllegalArgumentException("Not implemented for data type: " + dataBuffer.getDataType());
                    }
                    case 3: {
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        for (n14 = 0; n14 < dataBuffer.getNumBanks(); ++n14) {
                            for (n13 = 0; n13 < n6; ++n13) {
                                n12 = n13 * n7;
                                for (int k = 0; k < n7; ++k) {
                                    n11 = n12 + k;
                                    n10 = dataBuffer.getElem(n14, n11);
                                    for (int i2 = 0; i2 < n9; ++i2) {
                                        byteBuffer.put((byte)(n10 >> nArray2[i2] & 0xFF));
                                    }
                                }
                                this.flushBuffer(byteBuffer, dataOutput);
                                if (!(dataOutput instanceof DataOutputStream)) continue;
                                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                                dataOutputStream.flush();
                            }
                        }
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Not implemented for data type: " + dataBuffer.getDataType());
                    }
                }
            }
            if (dataOutput instanceof DataOutputStream) {
                DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
                dataOutputStream.flush();
            }
            this.processImageProgress(100.0f * (float)i / (float)n3);
        }
        if (dataOutput instanceof DataOutputStream) {
            DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
            dataOutputStream.close();
        }
        this.processImageComplete();
    }

    private void flushBuffer(ByteBuffer byteBuffer, DataOutput dataOutput) throws IOException {
        byteBuffer.flip();
        dataOutput.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
        byteBuffer.clear();
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new TIFFImageWriteParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        int n2 = 0;
        int n3 = stringArray.length > n2 + 1 ? Integer.parseInt(stringArray[n2++]) : -1;
        int n4 = n = stringArray.length > n2 + 1 ? Integer.parseInt(stringArray[n2++]) : 0;
        if (stringArray.length <= n2) {
            System.err.println("No file specified");
            System.exit(1);
        }
        File file = new File(stringArray[n2++]);
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);){
            object5 = ImageIO.getImageReaders(imageInputStream);
            if (!object5.hasNext()) {
                System.err.println("No reader for: " + file);
                System.exit(1);
            }
            object4 = object5.next();
            ((ImageReader)object4).setInput(imageInputStream);
            object3 = ((ImageReader)object4).getDefaultReadParam();
            ((ImageReadParam)object3).setDestinationType(((ImageReader)object4).getRawImageType(0));
            if (((IIOParam)object3).getDestinationType() == null) {
                object2 = ((ImageReader)object4).getImageTypes(0);
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((ImageTypeSpecifier)object).getColorModel().getColorSpace().getType() != 9) continue;
                    ((ImageReadParam)object3).setDestinationType((ImageTypeSpecifier)object);
                }
            }
            System.err.println("param.getDestinationType(): " + ((IIOParam)object3).getDestinationType());
            bufferedImage = ((ImageReader)object4).read(0, (ImageReadParam)object3);
        }
        System.err.println("original: " + bufferedImage);
        if (n3 < 0 || n3 == bufferedImage.getType()) {
            object5 = bufferedImage;
        } else if (n3 == 13) {
            object5 = ImageUtil.createIndexed((Image)bufferedImage, (int)256, null, (int)259);
        } else {
            object5 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n3);
            object4 = ((BufferedImage)object5).createGraphics();
            try {
                ((Graphics)object4).drawImage(bufferedImage, 0, 0, null);
            }
            finally {
                ((Graphics)object4).dispose();
            }
        }
        bufferedImage = null;
        object4 = File.createTempFile(file.getName().replace('.', '-'), ".tif");
        System.err.println("output: " + object4);
        object3 = new TIFFImageWriter(null);
        object2 = ImageIO.createImageOutputStream(object4);
        try {
            object3.setOutput(object2);
            object = ((TIFFImageWriter)((Object)object3)).getDefaultWriteParam();
            ((ImageWriteParam)object).setCompressionMode(2);
            ((ImageWriteParam)object).setCompressionType(((ImageWriteParam)object).getCompressionTypes()[n]);
            System.err.println("compression: " + ((ImageWriteParam)object).getLocalizedCompressionTypeName());
            long l = System.currentTimeMillis();
            ((TIFFImageWriter)((Object)object3)).write(null, new IIOImage((RenderedImage)object5, null, null), (ImageWriteParam)object);
            System.err.println("Write time: " + (System.currentTimeMillis() - l) + " ms");
        }
        finally {
            object2.close();
        }
        System.err.println("output.length: " + ((File)object4).length());
        object5 = null;
        object = ImageIO.read((File)object4);
        System.err.println("read: " + object);
        TIFFImageReader.showIt((BufferedImage)object, ((File)object4).getName());
    }

    static final class TIFFEntry
    extends AbstractEntry {
        TIFFEntry(Object object, Object object2) {
            super(object, object2);
        }
    }
}

