/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.xml.syndication.itunes.types;

import java.text.NumberFormat;
import java.util.StringTokenizer;

public class Duration {
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    private long milliseconds;

    public Duration() {
    }

    public Duration(long milliseconds) {
        this.setMilliseconds(milliseconds);
    }

    public Duration(int hours, int minutes, int seconds) {
        this.setMilliseconds((long)hours * 3600000L + (long)minutes * 60000L + (long)seconds * 1000L);
    }

    public Duration(String duration) {
        StringTokenizer tok = new StringTokenizer(duration, ":");
        switch (tok.countTokens()) {
            case 2: {
                this.setMilliseconds(Long.parseLong(tok.nextToken()) * 60000L + Long.parseLong(tok.nextToken()) * 1000L);
                break;
            }
            case 3: {
                this.setMilliseconds(Long.parseLong(tok.nextToken()) * 3600000L + Long.parseLong(tok.nextToken()) * 60000L + Long.parseLong(tok.nextToken()) * 1000L);
                break;
            }
            default: {
                throw new RuntimeException("Illegal time value: " + duration);
            }
        }
    }

    public String toString() {
        Time time = new Time();
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setGroupingUsed(false);
        return nf.format(time.hours) + ":" + nf.format(time.minutes) + ":" + nf.format(time.seconds);
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    private class Time {
        int hours;
        int minutes;
        int seconds;

        public Time() {
            long time = Duration.this.getMilliseconds();
            this.hours = (int)(time / 3600000L);
            this.minutes = (int)((time -= (long)this.hours * 3600000L) / 60000L);
            this.seconds = (int)((time -= (long)this.minutes * 60000L) / 1000L);
        }
    }
}

