/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.listeners.BeanValidationListener;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public interface BeanValidationInitializationHelper {
    public void bootstrapBeanValidation(Map var1, AbstractSession var2, MetadataProject var3, ClassLoader var4);

    public static class BeanValidationInitializationHelperImpl
    implements BeanValidationInitializationHelper {
        public void bootstrapBeanValidation(Map puProperties, AbstractSession session, MetadataProject project, ClassLoader appClassLoader) {
            ValidatorFactory validatorFactory = this.getValidatorFactory(puProperties);
            if (validatorFactory != null) {
                ValidatorFactory beanValidatorFactory = validatorFactory;
                Class[] groupPrePersit = this.translateValidationGroups((String)puProperties.get("javax.persistence.validation.group.pre-persist"), appClassLoader);
                Class[] groupPreUpdate = this.translateValidationGroups((String)puProperties.get("javax.persistence.validation.group.pre-update"), appClassLoader);
                Class[] groupPreRemove = this.translateValidationGroups((String)puProperties.get("javax.persistence.validation.group.pre-remove"), appClassLoader);
                BeanValidationListener validationListener = new BeanValidationListener(beanValidatorFactory, groupPrePersit, groupPreUpdate, groupPreRemove);
                for (EntityAccessor accessor : project.getEntityAccessors()) {
                    accessor.getDescriptor().addInternalListener(validationListener);
                }
            }
        }

        private ValidatorFactory getValidatorFactory(Map puProperties) {
            ValidatorFactory validatorFactory = (ValidatorFactory)puProperties.get("javax.persistence.validation.factory");
            if (validatorFactory == null) {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            return validatorFactory;
        }

        private Class[] translateValidationGroups(String validationGroups, ClassLoader appClassLoader) {
            Class[] validationGroupsClasses = null;
            if (validationGroups != null && validationGroups.length() != 0) {
                String[] validationGroupClassNames = validationGroups.split(",");
                validationGroupsClasses = new Class[validationGroupClassNames.length];
                int i = 0;
                while (i < validationGroupClassNames.length) {
                    String validationGroupClassName = validationGroupClassNames[i];
                    try {
                        validationGroupsClasses[i] = this.loadClass(validationGroupClassName, appClassLoader);
                    }
                    catch (Exception e) {
                        throw PersistenceUnitLoadingException.exceptionLoadingClassWhileInitializingValidationGroups(validationGroupClassName, e);
                    }
                    ++i;
                }
            }
            return validationGroupsClasses;
        }

        private Class loadClass(String className, ClassLoader classLoader) throws PrivilegedActionException, ClassNotFoundException {
            Class loadedClass = null;
            loadedClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader)) : PrivilegedAccessHelper.getClassForName(className, true, classLoader);
            return loadedClass;
        }
    }
}

