/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Map;
import javax.persistence.LockModeType;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAQuery
extends DatabaseQuery {
    private String lockMode;
    private String jpqlString;
    private Map<String, Object> hints;

    public JPAQuery() {
    }

    public JPAQuery(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public JPAQuery(String name, String jpqlString, String lockMode, Map<String, Object> hints) {
        this.name = name;
        this.jpqlString = jpqlString;
        this.flushOnExecute = null;
        this.hints = hints;
        this.lockMode = lockMode;
        if (lockMode == null) {
            this.lockMode = "NONE";
        }
    }

    @Override
    public String getJPQLString() {
        return this.jpqlString;
    }

    @Override
    public void setJPQLString(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public void setHints(Map<String, Object> hints) {
        this.hints = hints;
    }

    public DatabaseQuery getDatabaseQuery() {
        return (DatabaseQuery)this.getProperty("databasequery");
    }

    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.setProperty("databasequery", databaseQuery);
    }

    @Override
    public void prepare() {
        this.setDatabaseQuery(this.processJPQLQuery(this.getSession()));
    }

    public DatabaseQuery processJPQLQuery(Session session) {
        ClassLoader classloader = session.getDatasourcePlatform().getConversionManager().getLoader();
        LockModeType lockModeEnum = null;
        try {
            lockModeEnum = LockModeType.valueOf(this.lockMode);
        }
        catch (Exception exception) {}
        DatabaseQuery ejbquery = EJBQueryImpl.buildEJBQLDatabaseQuery(this.getName(), this.jpqlString, (AbstractSession)session, lockModeEnum, this.hints, classloader);
        ejbquery.setName(this.getName());
        return ejbquery;
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        return this.getSession().executeQuery(this.getDatabaseQuery());
    }
}

