/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.handler.Handler;

public class HandlerAnnotationProcessor {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.util");
    public static final String NS_109 = "http://java.sun.com/xml/ns/javaee";
    public static final String PROTOCOL_SOAP11_TOKEN = "##SOAP11_HTTP";
    public static final String PROTOCOL_SOAP12_TOKEN = "##SOAP12_HTTP";
    public static final String PROTOCOL_XML_TOKEN = "##XML_HTTP";
    public static final QName QNAME_CHAIN_PORT_PATTERN = new QName("http://java.sun.com/xml/ns/javaee", "port-name-pattern");
    public static final QName QNAME_CHAIN_PROTOCOL_BINDING = new QName("http://java.sun.com/xml/ns/javaee", "protocol-bindings");
    public static final QName QNAME_CHAIN_SERVICE_PATTERN = new QName("http://java.sun.com/xml/ns/javaee", "service-name-pattern");
    public static final QName QNAME_HANDLER_CHAIN = new QName("http://java.sun.com/xml/ns/javaee", "handler-chain");
    public static final QName QNAME_HANDLER_CHAINS = new QName("http://java.sun.com/xml/ns/javaee", "handler-chains");
    public static final QName QNAME_HANDLER = new QName("http://java.sun.com/xml/ns/javaee", "handler");
    public static final QName QNAME_HANDLER_NAME = new QName("http://java.sun.com/xml/ns/javaee", "handler-name");
    public static final QName QNAME_HANDLER_CLASS = new QName("http://java.sun.com/xml/ns/javaee", "handler-class");
    public static final QName QNAME_HANDLER_PARAM = new QName("http://java.sun.com/xml/ns/javaee", "init-param");
    public static final QName QNAME_HANDLER_PARAM_NAME = new QName("http://java.sun.com/xml/ns/javaee", "param-name");
    public static final QName QNAME_HANDLER_PARAM_VALUE = new QName("http://java.sun.com/xml/ns/javaee", "param-value");
    public static final QName QNAME_HANDLER_HEADER = new QName("http://java.sun.com/xml/ns/javaee", "soap-header");
    public static final QName QNAME_HANDLER_ROLE = new QName("http://java.sun.com/xml/ns/javaee", "soap-role");

    public static HandlerAnnotationInfo buildHandlerInfo(Class clazz, QName serviceName, QName portName, String bindingId) {
        HandlerChain handlerChain = (clazz = HandlerAnnotationProcessor.checkClass(clazz)).getAnnotation(HandlerChain.class);
        if (handlerChain == null) {
            return null;
        }
        if (clazz.getAnnotation(SOAPMessageHandlers.class) != null) {
            throw new UtilException("util.handler.cannot.combine.soapmessagehandlers", new Object[0]);
        }
        InputStream iStream = HandlerAnnotationProcessor.getFileAsStream(clazz, handlerChain);
        XMLStreamReader reader = XMLStreamReaderFactory.createXMLStreamReader(iStream, true);
        XMLStreamReaderUtil.nextElementContent(reader);
        return HandlerAnnotationProcessor.parseHandlerFile(reader, clazz.getClassLoader(), serviceName, portName, bindingId);
    }

    static Class getClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException("util.handler.class.not.found", className);
        }
    }

    static Class checkClass(Class clazz) {
        if (!clazz.isAnnotationPresent(WebService.class)) {
            throw new UtilException("util.handler.no.webservice.annotation", clazz.getCanonicalName());
        }
        WebService webService = clazz.getAnnotation(WebService.class);
        String ei = webService.endpointInterface();
        if (ei.length() > 0 && !(clazz = HandlerAnnotationProcessor.getClass(webService.endpointInterface())).isAnnotationPresent(WebService.class)) {
            throw new UtilException("util.handler.endpoint.interface.no.webservice", webService.endpointInterface());
        }
        return clazz;
    }

    public static HandlerAnnotationInfo parseHandlerFile(XMLStreamReader reader, ClassLoader classLoader, QName serviceName, QName portName, String bindingId) {
        HandlerAnnotationInfo info = new HandlerAnnotationInfo();
        XMLStreamReaderUtil.nextElementContent(reader);
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        HashSet<String> roles = new HashSet<String>();
        while (reader.getName().equals(QNAME_HANDLER_CHAIN)) {
            boolean parseChain;
            XMLStreamReaderUtil.nextElementContent(reader);
            if (reader.getName().equals(QNAME_CHAIN_PORT_PATTERN)) {
                if (portName == null) {
                    logger.warning("handler chain sepcified for port but port QName passed to parser is null");
                }
                if (!(parseChain = JAXWSUtils.matchQNames(portName, XMLStreamReaderUtil.getElementQName(reader)))) {
                    HandlerAnnotationProcessor.skipChain(reader);
                    continue;
                }
                XMLStreamReaderUtil.nextElementContent(reader);
            } else if (reader.getName().equals(QNAME_CHAIN_PROTOCOL_BINDING)) {
                if (bindingId == null) {
                    logger.warning("handler chain sepcified for bindingId but bindingId passed to parser is null");
                }
                String bindingList = XMLStreamReaderUtil.getElementText(reader);
                boolean skipThisChain = true;
                if (bindingId.equals("http://www.w3.org/2004/08/wsdl/http") && bindingList.indexOf(PROTOCOL_XML_TOKEN) != -1) {
                    skipThisChain = false;
                } else if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && bindingList.indexOf(PROTOCOL_SOAP11_TOKEN) != -1) {
                    skipThisChain = false;
                } else if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && bindingList.indexOf(PROTOCOL_SOAP12_TOKEN) != -1) {
                    skipThisChain = false;
                }
                if (skipThisChain) {
                    HandlerAnnotationProcessor.skipChain(reader);
                    continue;
                }
                XMLStreamReaderUtil.nextElementContent(reader);
            } else if (reader.getName().equals(QNAME_CHAIN_SERVICE_PATTERN)) {
                if (serviceName == null) {
                    logger.warning("handler chain sepcified for service but service QName passed to parser is null");
                }
                if (!(parseChain = JAXWSUtils.matchQNames(serviceName, XMLStreamReaderUtil.getElementQName(reader)))) {
                    HandlerAnnotationProcessor.skipChain(reader);
                    continue;
                }
                XMLStreamReaderUtil.nextElementContent(reader);
            }
            while (reader.getName().equals(QNAME_HANDLER)) {
                Handler handler = null;
                XMLStreamReaderUtil.nextContent(reader);
                if (reader.getName().equals(QNAME_HANDLER_NAME)) {
                    HandlerAnnotationProcessor.skipTextElement(reader);
                }
                HandlerAnnotationProcessor.ensureProperName(reader, QNAME_HANDLER_CLASS);
                try {
                    handler = (Handler)HandlerAnnotationProcessor.loadClass(classLoader, XMLStreamReaderUtil.getElementText(reader)).newInstance();
                }
                catch (InstantiationException ie) {
                    throw new RuntimeException(ie);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                XMLStreamReaderUtil.nextContent(reader);
                while (reader.getName().equals(QNAME_HANDLER_PARAM)) {
                    HandlerAnnotationProcessor.skipInitParamElement(reader);
                }
                while (reader.getName().equals(QNAME_HANDLER_HEADER)) {
                    HandlerAnnotationProcessor.skipTextElement(reader);
                }
                while (reader.getName().equals(QNAME_HANDLER_ROLE)) {
                    roles.add(XMLStreamReaderUtil.getElementText(reader));
                    XMLStreamReaderUtil.nextContent(reader);
                }
                for (Method method : handler.getClass().getMethods()) {
                    if (method.getAnnotation(PostConstruct.class) == null) continue;
                    try {
                        method.invoke((Object)handler, new Object[0]);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                handlerChain.add(handler);
                HandlerAnnotationProcessor.ensureProperName(reader, QNAME_HANDLER);
                XMLStreamReaderUtil.nextContent(reader);
            }
            HandlerAnnotationProcessor.ensureProperName(reader, QNAME_HANDLER_CHAIN);
            XMLStreamReaderUtil.nextContent(reader);
        }
        info.setHandlers(handlerChain);
        info.setRoles(roles);
        return info;
    }

    static void ensureProperName(XMLStreamReader reader, String expectedName) {
        if (!reader.getLocalName().equals(expectedName)) {
            HandlerAnnotationProcessor.failWithLocalName("util.parser.wrong.element", reader, expectedName);
        }
    }

    static void failWithLocalName(String key, XMLStreamReader reader, String arg) {
        throw new UtilException(key, Integer.toString(reader.getLocation().getLineNumber()), reader.getLocalName(), arg);
    }

    static Class loadClass(ClassLoader loader, String name) {
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException("util.handler.class.not.found", name);
        }
    }

    static void skipTextElement(XMLStreamReader reader) {
        XMLStreamReaderUtil.nextContent(reader);
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    static void skipInitParamElement(XMLStreamReader reader) {
        int state;
        while ((state = XMLStreamReaderUtil.nextContent(reader)) != 2 || !reader.getName().equals(QNAME_HANDLER_PARAM)) {
        }
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    static void skipChain(XMLStreamReader reader) {
        while (XMLStreamReaderUtil.nextContent(reader) != 2 || !reader.getName().equals(QNAME_HANDLER_CHAIN)) {
        }
        XMLStreamReaderUtil.nextElementContent(reader);
    }

    static void ensureProperName(XMLStreamReader reader, QName expectedName) {
        if (!reader.getName().equals(expectedName)) {
            HandlerAnnotationProcessor.failWithLocalName("util.parser.wrong.element", reader, expectedName.getLocalPart());
        }
    }

    static InputStream getFileAsStream(Class clazz, HandlerChain chain) {
        URL url = clazz.getResource(chain.file());
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(chain.file());
        }
        if (url == null) {
            String tmp = clazz.getPackage().getName();
            tmp = tmp.replace('.', '/');
            tmp = tmp + "/" + chain.file();
            url = Thread.currentThread().getContextClassLoader().getResource(tmp);
        }
        if (url == null) {
            throw new UtilException("util.failed.to.find.handlerchain.file", clazz.getName(), chain.file());
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new UtilException("util.failed.to.parse.handlerchain.file", clazz.getName(), chain.file());
        }
    }
}

