/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.client;

import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.dispatch.DispatchContext;
import com.sun.xml.ws.client.dispatch.impl.encoding.DispatchSerializer;
import com.sun.xml.ws.encoding.internal.InternalEncoder;
import com.sun.xml.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.simpletype.EncoderUtils;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.encoding.soap.SOAPDecoder;
import com.sun.xml.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.streaming.SourceReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.SOAPConnectionUtil;
import com.sun.xml.ws.util.xml.StAXSource;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Node;

public class SOAPXMLDecoder
extends SOAPDecoder {
    protected DispatchSerializer getSerializerInstance() {
        return DispatchSerializer.SOAP_1_0;
    }

    public SOAPMessage toSOAPMessage(MessageInfo messageInfo) {
        WSConnection connection = messageInfo.getConnection();
        return SOAPConnectionUtil.getSOAPMessage(connection, messageInfo, this.getBindingId());
    }

    protected void decodeEnvelope(XMLStreamReader reader, InternalMessage request, boolean skipBody, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        if (this.isDispatch(messageInfo)) {
            this.dispatchUtil.collectPrefixes(reader);
        }
        XMLStreamReaderUtil.nextElementContent(reader);
        if (this.skipHeader(messageInfo)) {
            this.skipHeader(reader, messageInfo);
        } else {
            this.decodeHeader(reader, messageInfo, request);
        }
        if (skipBody) {
            this.skipBody(reader);
        } else {
            this.decodeBody(reader, request, messageInfo);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 8);
    }

    private static String convertNull(String s) {
        return s != null ? s : "";
    }

    protected void decodeBody(XMLStreamReader reader, InternalMessage response, MessageInfo messageInfo) {
        DispatchContext context = (DispatchContext)messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context");
        if (context != null) {
            XMLStreamReaderUtil.verifyReaderState(reader, 1);
            XMLStreamReaderUtil.verifyTag(reader, this.getBodyTag());
            int state = XMLStreamReaderUtil.nextElementContent(reader);
            if (state != 2) {
                BodyBlock responseBody;
                QName responseBodyName = reader.getName();
                if (responseBodyName.equals(this.getFaultTag())) {
                    SOAPFaultInfo soapFaultInfo = this.decodeFault(reader, response, messageInfo);
                    responseBody = new BodyBlock(soapFaultInfo);
                } else {
                    JAXBContext jaxbContext = this.getJAXBContext(messageInfo);
                    if (jaxbContext == null) {
                        responseBody = new BodyBlock(this.getSerializerInstance().deserializeSource(reader, this.dispatchUtil));
                    } else {
                        JAXBBeanInfo jaxBean = JAXBBeanInfo.fromStAX(reader, jaxbContext);
                        responseBody = new BodyBlock(jaxBean);
                    }
                }
                response.setBody(responseBody);
            }
            XMLStreamReaderUtil.verifyReaderState(reader, 2);
            XMLStreamReaderUtil.verifyTag(reader, this.getBodyTag());
            XMLStreamReaderUtil.nextElementContent(reader);
        } else {
            super.decodeBody(reader, response, messageInfo);
        }
    }

    public void toMessageInfo(InternalMessage internalMessage, MessageInfo messageInfo) {
        RuntimeContext rtContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.ws.runtime.context");
        if (rtContext != null) {
            SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            InternalEncoder encoder = eptf.getInternalEncoder();
            encoder.toMessageInfo(internalMessage, messageInfo);
        } else if (internalMessage != null && internalMessage.getBody() != null) {
            if (internalMessage.getBody().getValue() instanceof SOAPFaultInfo) {
                messageInfo.setResponseType(1);
                messageInfo.setResponse(internalMessage.getBody().getValue());
            } else if (internalMessage.getBody().getValue() instanceof Exception) {
                messageInfo.setResponseType(2);
                messageInfo.setResponse(internalMessage.getBody().getValue());
            } else {
                messageInfo.setResponseType(0);
                if (internalMessage.getBody().getValue() instanceof JAXBBeanInfo) {
                    messageInfo.setResponse(((JAXBBeanInfo)internalMessage.getBody().getValue()).getBean());
                } else {
                    messageInfo.setResponse(internalMessage.getBody().getValue());
                }
            }
        } else {
            messageInfo.setResponseType(0);
        }
    }

    protected void decodeEnvelope(XMLStreamReader reader, MessageInfo messageInfo) {
        InternalMessage im = this.decodeInternalMessage(reader, messageInfo);
        this.toMessageInfo(im, messageInfo);
    }

    protected InternalMessage decodeInternalMessage(XMLStreamReader reader, MessageInfo messageInfo) {
        InternalMessage response = new InternalMessage();
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        XMLStreamReaderUtil.verifyTag(reader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        this.decodeHeader(reader, messageInfo, response);
        this.decodeBody(reader, response, messageInfo);
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 8);
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalMessage toInternalMessage(SOAPMessage soapMessage, MessageInfo messageInfo) {
        InternalMessage internalMessage;
        block6: {
            XMLStreamReader reader = null;
            try {
                InternalMessage response = new InternalMessage();
                this.processAttachments(messageInfo, response, soapMessage);
                Source source = soapMessage.getSOAPPart().getContent();
                reader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(soapMessage));
                XMLStreamReaderUtil.nextElementContent(reader);
                this.decodeEnvelope(reader, response, false, messageInfo);
                internalMessage = response;
                if (reader == null) break block6;
            }
            catch (DeserializationException e) {
                try {
                    throw new WebServiceException(e.getCause());
                    catch (Exception e2) {
                        throw new WebServiceException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        XMLStreamReaderUtil.close(reader);
                    }
                    throw throwable;
                }
            }
            XMLStreamReaderUtil.close(reader);
        }
        return internalMessage;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalMessage toInternalMessage(SOAPMessage soapMessage, InternalMessage response, MessageInfo messageInfo) {
        XMLStreamReader reader = null;
        try {
            this.processAttachments(messageInfo, response, soapMessage);
            Source source = soapMessage.getSOAPPart().getContent();
            reader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(soapMessage));
            XMLStreamReaderUtil.nextElementContent(reader);
            this.decodeEnvelope(reader, response, !this.isDispatch(messageInfo), messageInfo);
            if (!this.isDispatch(messageInfo)) {
                this.convertBodyBlock(response, messageInfo);
            }
            if (reader == null) return response;
        }
        catch (DeserializationException e) {
            try {
                throw new WebServiceException(e.getCause());
                catch (Exception e2) {
                    throw new WebServiceException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                XMLStreamReaderUtil.close(reader);
                throw throwable;
            }
        }
        XMLStreamReaderUtil.close(reader);
        return response;
    }

    public String getSOAPBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected SOAPFaultInfo decodeFault(XMLStreamReader reader, InternalMessage internalMessage, MessageInfo messageInfo) {
        Object faultdetail;
        String faultactor;
        String faultstring;
        QName faultcode;
        block13: {
            Method methodName;
            RuntimeContext rtCtxt;
            block11: {
                block12: {
                    rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
                    XMLStreamReaderUtil.verifyReaderState(reader, 1);
                    XMLStreamReaderUtil.verifyTag(reader, SOAPConstants.QNAME_SOAP_FAULT);
                    methodName = messageInfo.getMethod();
                    XMLStreamReaderUtil.nextElementContent(reader);
                    XMLStreamReaderUtil.verifyReaderState(reader, 1);
                    XMLStreamReaderUtil.verifyTag(reader, SOAPConstants.QNAME_SOAP_FAULT_CODE);
                    XMLStreamReaderUtil.nextContent(reader);
                    String tokens = reader.getText();
                    String uri = "";
                    tokens = EncoderUtils.collapseWhitespace(tokens);
                    String prefix = XmlUtil.getPrefix(tokens);
                    if (prefix != null && (uri = reader.getNamespaceURI(prefix)) == null) {
                        throw new DeserializationException("xsd.unknownPrefix", prefix);
                    }
                    String localPart = XmlUtil.getLocalPart(tokens);
                    faultcode = new QName(uri, localPart);
                    XMLStreamReaderUtil.next(reader);
                    XMLStreamReaderUtil.verifyReaderState(reader, 2);
                    XMLStreamReaderUtil.verifyTag(reader, SOAPConstants.QNAME_SOAP_FAULT_CODE);
                    XMLStreamReaderUtil.nextElementContent(reader);
                    XMLStreamReaderUtil.verifyReaderState(reader, 1);
                    XMLStreamReaderUtil.verifyTag(reader, SOAPConstants.QNAME_SOAP_FAULT_STRING);
                    XMLStreamReaderUtil.nextContent(reader);
                    faultstring = null;
                    if (reader.getEventType() == 4) {
                        faultstring = reader.getText();
                        XMLStreamReaderUtil.next(reader);
                    }
                    XMLStreamReaderUtil.verifyReaderState(reader, 2);
                    XMLStreamReaderUtil.verifyTag(reader, SOAPConstants.QNAME_SOAP_FAULT_STRING);
                    faultactor = null;
                    faultdetail = null;
                    if (XMLStreamReaderUtil.nextElementContent(reader) != 1) break block11;
                    QName elementName = reader.getName();
                    if (elementName.equals(SOAPConstants.QNAME_SOAP_FAULT_ACTOR)) {
                        XMLStreamReaderUtil.nextContent(reader);
                        if (reader.getEventType() == 4) {
                            faultactor = reader.getText();
                            XMLStreamReaderUtil.next(reader);
                        }
                        XMLStreamReaderUtil.verifyReaderState(reader, 2);
                        XMLStreamReaderUtil.verifyTag(reader, SOAPConstants.QNAME_SOAP_FAULT_ACTOR);
                        XMLStreamReaderUtil.nextElementContent(reader);
                        elementName = reader.getName();
                    }
                    if (!elementName.equals(SOAPConstants.QNAME_SOAP_FAULT_DETAIL)) break block12;
                    XMLStreamReaderUtil.nextContent(reader);
                    if (messageInfo.getMetaData("com.sun.xml.ws.client.dispatch.context") == null) {
                        faultdetail = this.readFaultDetail(reader, messageInfo);
                    } else {
                        XMLStreamReaderUtil.skipElement(reader);
                        XMLStreamReaderUtil.next(reader);
                    }
                    XMLStreamReaderUtil.nextContent(reader);
                    break block13;
                }
                if (internalMessage.getHeaders() == null) break block13;
                boolean isHeaderFault = false;
                for (HeaderBlock headerBlock : internalMessage.getHeaders()) {
                    if (!rtCtxt.getModel().isKnownFault(headerBlock.getName(), methodName)) continue;
                    isHeaderFault = true;
                    faultdetail = headerBlock.getValue();
                }
                if (!isHeaderFault) {
                    faultdetail = null;
                }
                XMLStreamReaderUtil.next(reader);
                break block13;
            }
            if (internalMessage.getHeaders() != null) {
                for (HeaderBlock headerBlock : internalMessage.getHeaders()) {
                    if (!rtCtxt.getModel().isKnownFault(headerBlock.getName(), methodName)) continue;
                    faultdetail = headerBlock.getValue();
                }
            }
        }
        SOAPFaultInfo soapFaultInfo = new SOAPFaultInfo(faultstring, faultcode, faultactor, faultdetail, this.getBindingId());
        if (reader.getEventType() == 4 && reader.isWhiteSpace()) {
            XMLStreamReaderUtil.nextContent(reader);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 2);
        XMLStreamReaderUtil.verifyTag(reader, SOAPConstants.QNAME_SOAP_FAULT);
        XMLStreamReaderUtil.nextElementContent(reader);
        return soapFaultInfo;
    }

    protected final Object readFaultDetail(XMLStreamReader reader, MessageInfo mi) {
        Object decoderInfo;
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(mi);
        if (rtCtxt == null) {
            XMLStreamReaderUtil.skipElement(reader);
            XMLStreamReaderUtil.nextElementContent(reader);
            return null;
        }
        QName faultName = reader.getName();
        if (rtCtxt.getModel().isKnownFault(faultName, mi.getMethod()) && (decoderInfo = rtCtxt.getDecoderInfo(faultName)) != null && decoderInfo instanceof JAXBBridgeInfo) {
            JAXBBridgeInfo bridgeInfo = (JAXBBridgeInfo)decoderInfo;
            bridgeInfo.deserialize(reader, rtCtxt.getBridgeContext());
            XMLStreamReaderUtil.verifyReaderState(reader, 2);
            XMLStreamReaderUtil.verifyTag(reader, this.getFaultDetailTag());
            return bridgeInfo;
        }
        return this.decodeFaultDetail(reader);
    }

    protected Detail decodeFaultDetail(XMLStreamReader reader) {
        try {
            Transformer trans = XmlUtil.newTransformer();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage();
            Detail detail = soapMessage.getSOAPBody().addFault().addDetail();
            do {
                trans.transform(new StAXSource(reader, true), new DOMResult((Node)detail));
            } while (XMLStreamReaderUtil.nextContent(reader) == 1);
            return detail;
        }
        catch (SOAPException e) {
            throw new WebServiceException("sender.response.cannotDecodeFaultDetail", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new WebServiceException("sender.response.cannotDecodeFaultDetail", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new WebServiceException("sender.response.cannotDecodeFaultDetail", (Throwable)e);
        }
    }

    protected JAXBContext getJAXBContext(MessageInfo messageInfo) {
        JAXBContext jc = null;
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        if (requestContext != null) {
            jc = (JAXBContext)requestContext.copy().get("com.sun.xml.ws.jaxbcontext");
        }
        return jc;
    }

    protected String getBindingId(MessageInfo messageInfo) {
        String bindingId;
        RequestContext requestContext = (RequestContext)messageInfo.getMetaData("com.sun.xml.ws.context.request");
        if (requestContext != null && (bindingId = (String)requestContext.get("com.sun.xml.ws.binding")) != null) {
            return bindingId;
        }
        return this.getBindingId();
    }

    public String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    protected QName getSenderFaultCode() {
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    protected QName getReceiverFaultCode() {
        return SOAPConstants.FAULT_CODE_CLIENT;
    }

    protected QName getVersionMismatchFaultCode() {
        return SOAPConstants.FAULT_CODE_VERSION_MISMATCH;
    }
}

