/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.id.impl;

import java.util.Date;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.integration.DistributeIdGenerator;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.plugins.id.IdGenerator;
import org.sagacity.sqltoy.plugins.id.macro.MacroUtils;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisIdGenerator
implements IdGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(RedisIdGenerator.class);
    private DistributeIdGenerator distributeIdGenerator;

    @Override
    public void initialize(SqlToyContext sqlToyContext) throws Exception {
        if (this.distributeIdGenerator == null) {
            this.distributeIdGenerator = (DistributeIdGenerator)Class.forName(sqlToyContext.getDistributeIdGeneratorClass()).newInstance();
            this.distributeIdGenerator.initialize(sqlToyContext.getAppContext());
        }
    }

    @Override
    public Object getId(String tableName, String signature, String[] relatedColumns, Object[] relatedColValue, Date bizDate, String idJavaType, int length, int sequencSize) {
        String realKey;
        String key = signature == null ? "" : signature;
        IgnoreKeyCaseMap<String, Object> keyValueMap = new IgnoreKeyCaseMap<String, Object>();
        if (relatedColumns != null && relatedColumns.length > 0) {
            for (int i = 0; i < relatedColumns.length; ++i) {
                if (null == relatedColValue[i]) {
                    throw new RuntimeException("table=" + tableName + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u5931\u8d25,\u5173\u8054\u5b57\u6bb5:" + relatedColumns[i] + " \u5bf9\u5e94\u7684\u503c\u4e3anull!");
                }
                keyValueMap.put(relatedColumns[i], relatedColValue[i]);
            }
        }
        if ((realKey = MacroUtils.replaceMacros(key, keyValueMap)).equals(key) && (length <= 0 && sequencSize < 6 || length - realKey.length() > 6)) {
            Date realBizDate = bizDate == null ? new Date() : bizDate;
            realKey = realKey.concat(DateUtil.formatDate(realBizDate, "yyMMdd"));
        }
        if (!keyValueMap.isEmpty()) {
            realKey = MacroUtils.replaceParams(realKey, keyValueMap);
        }
        Long result = tableName != null ? Long.valueOf(this.distributeIdGenerator.generateId("".equals(realKey) ? tableName : tableName.concat(":").concat(realKey), 1, null)) : Long.valueOf(this.distributeIdGenerator.generateId(realKey, 1, null));
        return realKey.concat(StringUtil.addLeftZero2Len("" + result, sequencSize > 0 ? sequencSize : length - realKey.length()));
    }
}

