/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.RowCallbackHandler;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.link.BaseLink;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.plugins.CrossDbAdapter;
import org.sagacity.sqltoy.utils.BeanUtil;

public class Query
extends BaseLink {
    private static final long serialVersionUID = -8128694559008281052L;
    private String sql;
    private String[] names;
    private Object[] values;
    private Serializable entity;
    private Class<?> resultType;
    @Deprecated
    private RowCallbackHandler handler;
    private int fetchSize = -1;
    private int maxRows = -1;
    private Boolean humpMapLabel;
    private LockMode lockMode;

    public Query(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Query fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Deprecated
    public Query maxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public Query lock(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    @Deprecated
    public Query rowhandler(RowCallbackHandler handler) {
        this.handler = handler;
        return this;
    }

    public Query sql(String sql) {
        this.sql = sql;
        return this;
    }

    public Query humpMapLabel(Boolean isHump) {
        this.humpMapLabel = isHump;
        return this;
    }

    public Query names(String ... names) {
        this.names = names;
        return this;
    }

    public Query values(Object ... values) {
        this.values = values;
        return this;
    }

    public Query entity(Serializable entityVO) {
        this.entity = entityVO;
        return this;
    }

    public Query resultType(Class<?> resultType) {
        this.resultType = resultType;
        return this;
    }

    public Query dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.defaultDataSource = false;
        return this;
    }

    public <T> T getValue(Class<T> resultType) {
        Object result = this.getValue();
        try {
            return (T)BeanUtil.convertType(result, DataType.getType(resultType), resultType.getTypeName());
        }
        catch (Exception e) {
            throw new DataAccessException("getValue\u65b9\u6cd5\u83b7\u53d6\u5355\u4e2a\u503c\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    public Object getValue() {
        QueryExecutor queryExecute = new QueryExecutor(this.sql).names(this.names).values(this.values);
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecute, SqlType.search, this.getDialect());
        QueryResult result = this.dialectFactory.findByQuery(this.sqlToyContext, queryExecute, sqlToyConfig, null, this.getDataSource(sqlToyConfig));
        CrossDbAdapter.redoQuery(this.sqlToyContext, this.dialectFactory, queryExecute);
        List rows = result.getRows();
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        if (rows.size() == 1) {
            return ((List)rows.get(0)).get(0);
        }
        throw new IllegalArgumentException("getValue\u67e5\u8be2\u51fa:" + rows.size() + " \u6761\u8bb0\u5f55,\u4e0d\u7b26\u5408getValue \u5355\u884c\u8bb0\u5f55\u4e14\u5355\u503c\u9884\u671f!");
    }

    public Object getOne() {
        QueryExecutor queryExecute = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecute, SqlType.search, this.getDialect());
        QueryResult result = this.dialectFactory.findByQuery(this.sqlToyContext, queryExecute, sqlToyConfig, this.lockMode, this.getDataSource(sqlToyConfig));
        CrossDbAdapter.redoQuery(this.sqlToyContext, this.dialectFactory, queryExecute);
        List rows = result.getRows();
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        if (rows.size() == 1) {
            return rows.get(0);
        }
        throw new IllegalArgumentException("getOne\u67e5\u8be2\u51fa:" + rows.size() + " \u6761\u8bb0\u5f55,\u4e0d\u7b26\u5408getOne\u67e5\u8be2\u9884\u671f!");
    }

    public Long count() {
        QueryExecutor queryExecute = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecute, SqlType.search, this.getDialect());
        Long result = this.dialectFactory.getCountBySql(this.sqlToyContext, queryExecute, sqlToyConfig, this.getDataSource(sqlToyConfig));
        CrossDbAdapter.redoCountQuery(this.sqlToyContext, this.dialectFactory, queryExecute);
        return result;
    }

    public List<?> find() {
        QueryExecutor queryExecute = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecute, SqlType.search, this.getDialect());
        QueryResult result = this.dialectFactory.findByQuery(this.sqlToyContext, queryExecute, sqlToyConfig, this.lockMode, this.getDataSource(sqlToyConfig));
        CrossDbAdapter.redoQuery(this.sqlToyContext, this.dialectFactory, queryExecute);
        return result.getRows();
    }

    public List<?> findTop(double topSize) {
        QueryExecutor queryExecute = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecute, SqlType.search, this.getDialect());
        QueryResult result = this.dialectFactory.findTop(this.sqlToyContext, queryExecute, sqlToyConfig, topSize, this.getDataSource(sqlToyConfig));
        CrossDbAdapter.redoTopQuery(this.sqlToyContext, this.dialectFactory, queryExecute, topSize);
        return result.getRows();
    }

    public List<?> findRandom(double randomSize) {
        QueryExecutor queryExecute = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecute, SqlType.search, this.getDialect());
        QueryResult result = this.dialectFactory.getRandomResult(this.sqlToyContext, queryExecute, sqlToyConfig, randomSize, this.getDataSource(sqlToyConfig));
        CrossDbAdapter.redoRandomQuery(this.sqlToyContext, this.dialectFactory, queryExecute, randomSize);
        return result.getRows();
    }

    public Page<?> findPage(Page page) {
        QueryExecutor queryExecute = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecute, SqlType.search, this.getDialect());
        Page result = page.getSkipQueryCount() != false ? this.dialectFactory.findSkipTotalCountPage(this.sqlToyContext, queryExecute, sqlToyConfig, page.getPageNo(), page.getPageSize(), this.getDataSource(sqlToyConfig)).getPageResult() : this.dialectFactory.findPage(this.sqlToyContext, queryExecute, sqlToyConfig, page.getPageNo(), page.getPageSize(), page.getOverPageToFirst(), this.getDataSource(sqlToyConfig)).getPageResult();
        CrossDbAdapter.redoPageQuery(this.sqlToyContext, this.dialectFactory, queryExecute, page);
        return result;
    }

    private QueryExecutor build() {
        QueryExecutor queryExecutor = null;
        queryExecutor = this.entity != null ? new QueryExecutor(this.sql, this.entity) : new QueryExecutor(this.sql).names(this.names).values(this.values);
        if (this.resultType != null) {
            queryExecutor.resultType(this.resultType);
        }
        if (this.handler != null) {
            queryExecutor.rowCallbackHandler(this.handler);
        }
        queryExecutor.humpMapLabel(this.humpMapLabel);
        queryExecutor.maxRows(this.maxRows);
        queryExecutor.fetchSize(this.fetchSize);
        return queryExecutor;
    }
}

