/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PageOptimize;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.CollectionUtil;

public class PageOptimizeUtils {
    private static final int INITIAL_CAPACITY = 128;
    private static final float LOAD_FACTOR = 0.75f;
    private static ConcurrentHashMap<String, LinkedHashMap<String, Object[]>> pageOptimizeCache = new ConcurrentHashMap(128, 0.75f);

    public static String generateOptimizeKey(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, PageOptimize pageOptimize) throws Exception {
        String[] tenants;
        if (pageOptimize == null || pageOptimize.getAliveMax() <= 1 || pageOptimize.getAliveSeconds() < 1) {
            return null;
        }
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        String[] paramNames = extend.getParamsName();
        Object[] paramValues = extend.getParamsValue(sqlToyContext, sqlToyConfig);
        if (paramValues == null || paramValues.length == 0) {
            return sqlToyConfig.getIdOrSql();
        }
        StringBuilder cacheKey = new StringBuilder();
        boolean isParamsNamed = true;
        if (null == paramNames || paramNames.length == 0) {
            isParamsNamed = false;
        }
        int i = 0;
        for (Object value : paramValues) {
            if (i > 0) {
                cacheKey.append(",");
            }
            if (isParamsNamed) {
                cacheKey.append(paramNames[i]).append("=");
            } else {
                cacheKey.append("p_").append(i).append("=");
            }
            if (value == null) {
                cacheKey.append("null");
            } else if (value instanceof Object[] || value.getClass().isArray() || value instanceof List) {
                Object[] arrayValue = value instanceof List ? ((List)value).toArray() : CollectionUtil.convertArray(value);
                cacheKey.append("[");
                for (Object obj : arrayValue) {
                    cacheKey.append(obj == null ? "null" : obj.toString()).append(",");
                }
                cacheKey.append("]");
            } else {
                cacheKey.append(value.toString());
            }
            ++i;
        }
        if (sqlToyContext.getUnifyFieldsHandler() != null && (tenants = sqlToyContext.getUnifyFieldsHandler().authTenants(extend.entityClass, OperateType.page)) != null && tenants.length > 0) {
            if (i > 0) {
                cacheKey.append(",");
            }
            cacheKey.append("tenantIds=[");
            int meter = 0;
            for (String tenant : tenants) {
                if (meter > 0) {
                    cacheKey.append(",");
                }
                cacheKey.append(tenant);
                ++meter;
            }
        }
        return cacheKey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getPageTotalCount(SqlToyConfig sqlToyConfig, PageOptimize pageOptimize, String conditionsKey) {
        LinkedHashMap<String, Object[]> map;
        if (!pageOptimizeCache.containsKey(sqlToyConfig.getIdOrSql())) {
            return null;
        }
        LinkedHashMap<String, Object[]> linkedHashMap = map = pageOptimizeCache.get(sqlToyConfig.getIdOrSql());
        synchronized (linkedHashMap) {
            if (!map.containsKey(conditionsKey)) {
                return null;
            }
            Object[] values = map.get(conditionsKey);
            long expireTime = (Long)values[0];
            Long totalCount = (Long)values[1];
            long nowTime = System.currentTimeMillis();
            if (nowTime >= expireTime) {
                map.remove(conditionsKey);
                return null;
            }
            return totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registPageTotalCount(SqlToyConfig sqlToyConfig, PageOptimize pageOptimize, String conditionsKey, Long totalCount) {
        long nowTime = System.currentTimeMillis();
        long expireTime = nowTime + (long)(pageOptimize.getAliveSeconds() * 1000);
        int aliveMax = pageOptimize.getAliveMax();
        String id = sqlToyConfig.getIdOrSql();
        LinkedHashMap<Object, Object> map = null;
        if (!pageOptimizeCache.containsKey(id)) {
            map = new LinkedHashMap(aliveMax);
            map.put(conditionsKey, new Object[]{expireTime, totalCount});
            pageOptimizeCache.put(id, map);
        } else {
            LinkedHashMap<Object, Object> linkedHashMap = map = pageOptimizeCache.get(id);
            synchronized (linkedHashMap) {
                if (map.containsKey(conditionsKey)) {
                    map.remove(conditionsKey);
                }
                map.put(conditionsKey, new Object[]{expireTime, totalCount});
                while (map.size() > aliveMax) {
                    map.remove(map.keySet().iterator().next());
                }
            }
        }
    }

    public static void remove(String sqlId) {
        pageOptimizeCache.remove(sqlId);
    }
}

