/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.utils.StringUtil;

public class SqlWithAnalysis
implements Serializable {
    private static final long serialVersionUID = -5841684922722930298L;
    private final Pattern asPattern = Pattern.compile("\\Was");
    private String sql;
    private String withSql = "";
    private String rejectWithSql;
    private String preSql;
    private String footSql;
    private boolean hasWith = false;
    private List<String[]> withSqlSet = null;

    public SqlWithAnalysis(String sql) {
        this.sql = sql;
        this.parse();
    }

    public String getSql() {
        return this.sql;
    }

    public String getWithSql() {
        return this.withSql;
    }

    public String getRejectWithSql() {
        return this.rejectWithSql;
    }

    public List<String[]> getWithSqlSet() {
        return this.withSqlSet;
    }

    public String getPreSql() {
        return this.preSql;
    }

    public String getFootSql() {
        return this.footSql;
    }

    private void parse() {
        String aliasTable;
        String[] params;
        int bracketIndex;
        String withAsMiddle;
        int asIndex;
        String groupLow;
        String groupStr;
        String aliasParams;
        String withAfter;
        this.rejectWithSql = this.sql;
        String headSql = "";
        String tailSql = " ".concat(this.sql);
        StringBuilder withSqlBuffer = null;
        Matcher withAsMatcher = SqlToyConstants.withPattern.matcher(tailSql);
        if (withAsMatcher.find()) {
            withAfter = "";
            aliasParams = "";
            headSql = tailSql.substring(0, withAsMatcher.start() + 1);
            this.hasWith = true;
            withSqlBuffer = new StringBuilder();
            this.withSqlSet = new ArrayList<String[]>();
            groupStr = withAsMatcher.group();
            groupLow = groupStr.toLowerCase();
            asIndex = StringUtil.matchIndex(groupLow, this.asPattern) + 1;
            withAsMiddle = groupStr.substring(groupLow.indexOf("with") + 4, asIndex).trim();
            bracketIndex = withAsMiddle.indexOf("(");
            if (bracketIndex > 0 && withAsMiddle.endsWith(")")) {
                aliasParams = withAsMiddle.substring(bracketIndex);
                if ((withAsMiddle = withAsMiddle.substring(0, bracketIndex)).endsWith(" ")) {
                    aliasParams = " ".concat(aliasParams);
                    withAsMiddle = withAsMiddle.trim();
                }
            }
            params = withAsMiddle.split("\\s+");
            aliasTable = params[params.length - 1];
            if (params.length > 1) {
                withAfter = params[0];
            }
        } else {
            return;
        }
        String ext = groupStr.substring(asIndex + 2, groupStr.indexOf("(", asIndex));
        int endWith = StringUtil.getSymMarkIndex("(", ")", tailSql, withAsMatcher.start() + asIndex);
        withSqlBuffer.append(tailSql.substring(withAsMatcher.start() + 1, endWith + 1));
        this.withSqlSet.add(new String[]{aliasTable, ext, tailSql.substring(withAsMatcher.end(), endWith), withAfter, aliasParams});
        tailSql = tailSql.substring(endWith + 1);
        Matcher otherMatcher = SqlToyConstants.otherWithPattern.matcher(tailSql);
        while (otherMatcher.find() && otherMatcher.start() == 0) {
            withAfter = "";
            aliasParams = "";
            groupStr = otherMatcher.group();
            groupLow = groupStr.toLowerCase();
            asIndex = StringUtil.matchIndex(groupLow, this.asPattern) + 1;
            withAsMiddle = groupStr.substring(groupStr.indexOf(",") + 1, asIndex).trim();
            bracketIndex = withAsMiddle.indexOf("(");
            if (bracketIndex > 0 && withAsMiddle.endsWith(")")) {
                aliasParams = withAsMiddle.substring(bracketIndex);
                if ((withAsMiddle = withAsMiddle.substring(0, bracketIndex)).endsWith(" ")) {
                    aliasParams = " ".concat(aliasParams);
                    withAsMiddle = withAsMiddle.trim();
                }
            }
            params = withAsMiddle.split("\\s+");
            aliasTable = params[params.length - 1];
            if (params.length > 1) {
                withAfter = params[0];
            }
            ext = groupStr.substring(asIndex + 2, groupStr.indexOf("(", asIndex));
            endWith = StringUtil.getSymMarkIndex("(", ")", tailSql, otherMatcher.start() + asIndex);
            withSqlBuffer.append(tailSql.substring(0, endWith + 1));
            this.withSqlSet.add(new String[]{aliasTable, ext, tailSql.substring(otherMatcher.end(), endWith), withAfter, aliasParams});
            tailSql = tailSql.substring(endWith + 1);
            otherMatcher.reset(tailSql);
        }
        this.preSql = headSql.trim();
        this.footSql = tailSql.trim();
        this.rejectWithSql = headSql.concat(" ").concat(tailSql);
        this.withSql = withSqlBuffer.append(" ").toString();
    }

    public boolean isHasWith() {
        return this.hasWith;
    }

    public void setHasWith(boolean hasWith) {
        this.hasWith = hasWith;
    }
}

