/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.nosql;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.config.model.NoSqlFieldsModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.model.inner.DataSetResult;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.HttpClientUtils;
import org.sagacity.sqltoy.utils.MongoElasticUtils;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ElasticSearchUtils.class);

    public static DataSetResult executeQuery(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Class resultClass, Boolean humpMapLabel) throws Exception {
        NoSqlConfigModel noSqlModel = sqlToyConfig.getNoSqlConfigModel();
        ElasticEndpoint esConfig = sqlToyContext.getElasticEndpoint(noSqlModel.getEndpoint());
        boolean nativeSql = esConfig.isNativeSql() && noSqlModel.isSqlMode();
        JSONObject json = HttpClientUtils.doPost(sqlToyContext, noSqlModel, esConfig, sql);
        if (json == null || json.isEmpty()) {
            return new DataSetResult();
        }
        String[] fields = noSqlModel.getFields();
        if (fields == null) {
            if (json.containsKey((Object)"columns")) {
                JSONArray cols = json.getJSONArray("columns");
                fields = new String[cols.size()];
                int index = 0;
                for (Object col : cols) {
                    fields[index] = ((JSONObject)col).getString("name");
                    ++index;
                }
            } else if (!(resultClass == null || Array.class.isAssignableFrom(resultClass) || Collection.class.isAssignableFrom(resultClass) || Map.class.isAssignableFrom(resultClass))) {
                fields = BeanUtil.matchSetMethodNames(resultClass);
            }
        }
        DataSetResult resultSet = null;
        resultSet = nativeSql ? ElasticSearchUtils.extractSqlFieldValue(sqlToyContext, sqlToyConfig, json, fields) : ElasticSearchUtils.extractFieldValue(sqlToyContext, sqlToyConfig, json, fields);
        MongoElasticUtils.processTranslate(sqlToyContext, sqlToyConfig, resultSet.getRows(), resultSet.getLabelNames());
        boolean changedCols = ResultUtils.calculate(sqlToyContext.getDesensitizeProvider(), sqlToyConfig, resultSet, null, null);
        resultSet.setRows(ResultUtils.wrapQueryResult(sqlToyContext, resultSet.getRows(), StringUtil.humpFieldNames(resultSet.getLabelNames()), resultClass, changedCols, humpMapLabel, false, null, null));
        return resultSet;
    }

    private static DataSetResult extractSqlFieldValue(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, JSONObject json, String[] fields) {
        DataSetResult resultModel = new DataSetResult();
        Object realRoot = json.get((Object)"rows");
        if (realRoot == null) {
            return resultModel;
        }
        NoSqlFieldsModel fieldModel = MongoElasticUtils.processFields(fields, null);
        JSONArray rows = (JSONArray)realRoot;
        ArrayList resultSet = new ArrayList();
        for (Object row : rows) {
            JSONArray item = (JSONArray)row;
            ArrayList result = new ArrayList();
            for (Object cel : item) {
                result.add(cel);
            }
            resultSet.add(result);
        }
        resultModel.setRows(resultSet);
        resultModel.setLabelNames(fieldModel.getAliasLabels());
        return resultModel;
    }

    public static DataSetResult extractFieldValue(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, JSONObject json, String[] fields) {
        String[] stringArray;
        if (sqlToyConfig.getNoSqlConfigModel().isHasAggs() || json.getJSONObject("aggregations") != null) {
            return ElasticSearchUtils.extractAggsFieldValue(sqlToyContext, sqlToyConfig, json, fields);
        }
        if (json.containsKey((Object)"suggest")) {
            return ElasticSearchUtils.extractSuggestFieldValue(sqlToyContext, sqlToyConfig, json, fields);
        }
        DataSetResult resultModel = new DataSetResult();
        JSONObject hits = json.getJSONObject("hits");
        if (hits != null && hits.containsKey((Object)"total")) {
            Object total = hits.get((Object)"total");
            if (total instanceof JSONObject) {
                resultModel.setRecordCount(((JSONObject)total).getLong("value"));
            } else {
                resultModel.setRecordCount(Long.parseLong(total.toString()));
            }
        }
        NoSqlConfigModel nosqlConfig = sqlToyConfig.getNoSqlConfigModel();
        ArrayList result = new ArrayList();
        if (nosqlConfig.getValueRoot() == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "hits";
            stringArray = stringArray2;
            stringArray2[1] = "hits";
        } else {
            stringArray = nosqlConfig.getValueRoot();
        }
        String[] valuePath = stringArray;
        JSONObject root = json;
        String lastKey = valuePath[valuePath.length - 1];
        for (int i = 0; i < valuePath.length - 1; ++i) {
            if (root == null) {
                return resultModel;
            }
            root = root.getJSONObject(valuePath[i]);
        }
        Object realRoot = root.get((Object)lastKey);
        if (realRoot == null) {
            return resultModel;
        }
        NoSqlFieldsModel fieldModel = MongoElasticUtils.processFields(fields, null);
        String[] realFields = fieldModel.getFields();
        if (realRoot instanceof JSONArray) {
            JSONArray array = (JSONArray)realRoot;
            for (int i = 0; i < array.size(); ++i) {
                JSONObject rowJson = (JSONObject)array.get(i);
                JSONObject sourceData = rowJson.getJSONObject("_source");
                ElasticSearchUtils.addRow(result, sourceData, realFields);
            }
        } else if (realRoot instanceof JSONObject) {
            ElasticSearchUtils.addRow(result, (JSONObject)realRoot, realFields);
        }
        resultModel.setRows(result);
        resultModel.setLabelNames(fieldModel.getAliasLabels());
        return resultModel;
    }

    private static DataSetResult extractSuggestFieldValue(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, JSONObject json, String[] fields) {
        String[] stringArray;
        DataSetResult resultModel = new DataSetResult();
        NoSqlFieldsModel fieldModel = MongoElasticUtils.processFields(fields, null);
        String[] realFields = fieldModel.getFields();
        if (sqlToyConfig.getNoSqlConfigModel().getValueRoot() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "suggest";
        } else {
            stringArray = sqlToyConfig.getNoSqlConfigModel().getValueRoot();
        }
        String[] rootPath = stringArray;
        Object root = json;
        if (!"suggest".equals(rootPath[0].toLowerCase())) {
            root = root.get((Object)"suggest");
        }
        for (String str : rootPath) {
            root = root.get((Object)str);
        }
        if (root == null) {
            logger.error("\u8bf7\u6b63\u786e\u914d\u7f6ees\u805a\u5408\u67e5\u8be2,\u5305\u62ec:fields\u914d\u7f6e\u662f\u5426\u5339\u914d\u7b49!");
            return resultModel;
        }
        ArrayList result = new ArrayList();
        if (root instanceof JSONObject) {
            ElasticSearchUtils.processRow(result, root, realFields, true);
        } else if (root instanceof JSONArray) {
            JSONArray array = (JSONArray)root;
            for (Object tmp : array) {
                ElasticSearchUtils.processRow(result, (JSONObject)tmp, realFields, true);
            }
        }
        if (result != null) {
            resultModel.setRecordCount(Long.valueOf(result.size()));
        }
        resultModel.setRows(result);
        resultModel.setLabelNames(fieldModel.getAliasLabels());
        return resultModel;
    }

    public static DataSetResult extractAggsFieldValue(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, JSONObject json, String[] fields) {
        String[] stringArray;
        DataSetResult resultModel = new DataSetResult();
        NoSqlFieldsModel fieldModel = MongoElasticUtils.processFields(fields, null);
        String[] realFields = fieldModel.getFields();
        if (sqlToyConfig.getNoSqlConfigModel().getValueRoot() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "aggregations";
        } else {
            stringArray = sqlToyConfig.getNoSqlConfigModel().getValueRoot();
        }
        String[] rootPath = stringArray;
        Object root = json;
        if (!"aggregations".equals(rootPath[0].toLowerCase())) {
            root = root.get((Object)"aggregations");
        }
        for (String str : rootPath) {
            root = root.get((Object)str);
        }
        while (root != null && root instanceof JSONObject) {
            Object tmp = root;
            if (tmp.containsKey((Object)"buckets")) {
                root = tmp.get((Object)"buckets");
                break;
            }
            int matchCnt = 0;
            block2: for (String key : tmp.keySet()) {
                for (String field : realFields) {
                    if (!key.equalsIgnoreCase(field)) continue;
                    ++matchCnt;
                    continue block2;
                }
            }
            if (matchCnt > 0) {
                root = tmp;
                break;
            }
            if (tmp.keySet().size() != 1) continue;
            root = tmp.values().iterator().next();
        }
        if (root == null) {
            logger.error("\u8bf7\u6b63\u786e\u914d\u7f6ees\u805a\u5408\u67e5\u8be2,\u5305\u62ec:fields\u914d\u7f6e\u662f\u5426\u5339\u914d\u7b49!");
            return resultModel;
        }
        ArrayList result = new ArrayList();
        if (root instanceof JSONObject) {
            ElasticSearchUtils.processRow(result, root, realFields, false);
        } else if (root instanceof JSONArray) {
            JSONArray array = (JSONArray)root;
            for (Object tmp : array) {
                ElasticSearchUtils.processRow(result, (JSONObject)tmp, realFields, false);
            }
        }
        if (result != null) {
            resultModel.setRecordCount(Long.valueOf(result.size()));
        }
        resultModel.setRows(result);
        resultModel.setLabelNames(fieldModel.getAliasLabels());
        return resultModel;
    }

    private static void processRow(List result, JSONObject rowJson, String[] realFields, boolean isSuggest) {
        Object root = ElasticSearchUtils.getRealJSONObject(rowJson, realFields, isSuggest);
        if (root instanceof JSONObject) {
            JSONObject json = (JSONObject)root;
            if (json.containsKey((Object)"key") && json.containsKey((Object)"doc_count")) {
                if (ElasticSearchUtils.isRoot(json, realFields)) {
                    ElasticSearchUtils.addRow(result, json, realFields);
                } else {
                    ElasticSearchUtils.processRow(result, json, realFields, isSuggest);
                }
            } else {
                ElasticSearchUtils.addRow(result, json, realFields);
            }
        } else if (root instanceof JSONArray) {
            JSONArray array = (JSONArray)root;
            for (Object tmp : array) {
                ElasticSearchUtils.processRow(result, (JSONObject)tmp, realFields, isSuggest);
            }
        }
    }

    private static boolean isRoot(JSONObject json, String[] realFields) {
        int mapCnt = 0;
        for (String key : realFields) {
            if (!json.containsKey((Object)key)) continue;
            ++mapCnt;
        }
        if (mapCnt == 0) {
            return false;
        }
        return mapCnt == realFields.length || mapCnt > 1;
    }

    private static void addRow(List result, JSONObject rowJson, String[] realFields) {
        ArrayList<Object> row = new ArrayList<Object>();
        for (String str : realFields) {
            Object cell = rowJson.get((Object)str);
            if (cell instanceof JSONObject) {
                row.add(((JSONObject)cell).get((Object)"value"));
                continue;
            }
            row.add(cell);
        }
        result.add(row);
    }

    private static Object getRealJSONObject(JSONObject rowJson, String[] realFields, boolean isSuggest) {
        Object result = rowJson.get((Object)"_source");
        if (result != null && result instanceof JSONObject) {
            return result;
        }
        result = rowJson.get((Object)"buckets");
        if (result != null) {
            if (result instanceof JSONArray) {
                return result;
            }
            if (result instanceof JSONObject) {
                return ElasticSearchUtils.getRealJSONObject((JSONObject)result, realFields, isSuggest);
            }
        }
        if ((result = rowJson.get((Object)"hits")) != null) {
            if (result instanceof JSONArray) {
                return result;
            }
            if (result instanceof JSONObject) {
                return ElasticSearchUtils.getRealJSONObject((JSONObject)result, realFields, isSuggest);
            }
        }
        if (isSuggest && (result = rowJson.get((Object)"options")) != null) {
            if (result instanceof JSONArray) {
                return result;
            }
            if (result instanceof JSONObject) {
                return ElasticSearchUtils.getRealJSONObject((JSONObject)result, realFields, isSuggest);
            }
        }
        if (rowJson.containsKey((Object)"key") && rowJson.containsKey((Object)"doc_count")) {
            Object[] keys;
            if (ElasticSearchUtils.isRoot(rowJson, realFields)) {
                return rowJson;
            }
            for (Object key : keys = rowJson.keySet().toArray()) {
                if ("key".equals(key) || "doc_count".equals(key)) continue;
                result = rowJson.get((Object)key.toString());
                if (result instanceof JSONObject) {
                    return ElasticSearchUtils.getRealJSONObject((JSONObject)result, realFields, isSuggest);
                }
                return result;
            }
        } else if (rowJson.keySet().size() == 1) {
            if (((String)rowJson.keySet().iterator().next()).equalsIgnoreCase(realFields[0]) && realFields.length == 1) {
                return rowJson;
            }
            result = rowJson.values().iterator().next();
            if (result instanceof JSONObject) {
                JSONObject tmp = (JSONObject)result;
                if (tmp.keySet().size() == 1 && "value".equals(((String)tmp.keySet().iterator().next()).toLowerCase())) {
                    return rowJson;
                }
                return ElasticSearchUtils.getRealJSONObject(tmp, realFields, isSuggest);
            }
            if (result instanceof JSONArray) {
                return result;
            }
        }
        return rowJson;
    }
}

