/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.plugins.function.IFunction;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.StringUtil;

public class FunctionUtils {
    private static final String funPackage = "org.sagacity.sqltoy.plugins.function.impl.";
    public static final String[] functions = new String[]{"org.sagacity.sqltoy.plugins.function.impl.".concat("SubStr"), "org.sagacity.sqltoy.plugins.function.impl.".concat("Trim"), "org.sagacity.sqltoy.plugins.function.impl.".concat("Instr"), "org.sagacity.sqltoy.plugins.function.impl.".concat("Concat"), "org.sagacity.sqltoy.plugins.function.impl.".concat("ConcatWs"), "org.sagacity.sqltoy.plugins.function.impl.".concat("Nvl"), "org.sagacity.sqltoy.plugins.function.impl.".concat("DateFormat"), "org.sagacity.sqltoy.plugins.function.impl.".concat("Now"), "org.sagacity.sqltoy.plugins.function.impl.".concat("Length"), "org.sagacity.sqltoy.plugins.function.impl.".concat("ToChar"), "org.sagacity.sqltoy.plugins.function.impl.".concat("If"), "org.sagacity.sqltoy.plugins.function.impl.".concat("GroupConcat")};
    private static final Map<String, String> functionNames = new HashMap<String, String>(){
        {
            this.put("substr", "SubStr");
            this.put("trim", "Trim");
            this.put("instr", "Instr");
            this.put("concat", "Concat");
            this.put("concatws", "ConcatWs");
            this.put("nvl", "Nvl");
            this.put("dateformat", "DateFormat");
            this.put("now", "Now");
            this.put("length", "Length");
            this.put("tochar", "ToChar");
            this.put("if", "If");
            this.put("groupconcat", "GroupConcat");
        }
    };
    private static List<IFunction> functionConverts = new ArrayList<IFunction>();

    public static String getDialectSql(String sql, String dialect) {
        if (functionConverts.isEmpty() || StringUtil.isBlank(dialect) || StringUtil.isBlank(sql)) {
            return sql;
        }
        return FunctionUtils.convertFunctions(dialect, sql);
    }

    private static String convertFunctions(String dialect, String sqlContent) {
        int dbType = DataSourceUtils.getDBType(dialect);
        String dialectSql = sqlContent;
        String dialectLow = dialect.toLowerCase();
        for (int i = 0; i < functionConverts.size(); ++i) {
            IFunction function = functionConverts.get(i);
            if (!StringUtil.isBlank(function.dialects()) && !function.dialects().toLowerCase().contains(dialectLow)) continue;
            dialectSql = FunctionUtils.replaceFunction(dialectSql, dbType, function);
        }
        return dialectSql;
    }

    private static String replaceFunction(String sqlContent, int dbType, IFunction function) {
        String dialectSql = sqlContent;
        Matcher matcher = function.regex().matcher(dialectSql);
        int index = -1;
        String[] args = null;
        int endMarkIndex = -1;
        StringBuilder result = new StringBuilder();
        String functionName = null;
        boolean hasArgs = true;
        while (matcher.find()) {
            index = matcher.start();
            String matchedGroup = matcher.group();
            hasArgs = matchedGroup.endsWith("(");
            int matchedIndex = index + 1;
            if (hasArgs) {
                functionName = dialectSql.substring(matchedIndex, dialectSql.indexOf("(", matchedIndex));
                endMarkIndex = StringUtil.getSymMarkIndex("(", ")", dialectSql, matchedIndex);
                String functionParams = dialectSql.substring(dialectSql.indexOf("(", matchedIndex) + 1, endMarkIndex);
                if (StringUtil.matches(functionParams, function.regex())) {
                    functionParams = FunctionUtils.replaceFunction(functionParams, dbType, function);
                }
                args = StringUtil.splitExcludeSymMark(functionParams, ",", SqlToyConstants.filters);
            } else {
                args = null;
                endMarkIndex = matcher.end() - 1;
                functionName = dialectSql.substring(matchedIndex, endMarkIndex);
            }
            String wrapResult = function.wrap(dbType, functionName, hasArgs, args);
            if (null == wrapResult) {
                result.append(dialectSql.substring(0, endMarkIndex + 1));
            } else {
                result.append(dialectSql.substring(0, matchedIndex)).append(wrapResult);
            }
            dialectSql = hasArgs ? dialectSql.substring(endMarkIndex + 1) : dialectSql.substring(endMarkIndex);
            matcher.reset(dialectSql);
        }
        result.append(dialectSql);
        return result.toString();
    }

    public static void setFunctionConverts(List<String> functionAry) {
        if (functionAry == null || functionAry.isEmpty()) {
            return;
        }
        ArrayList<IFunction> converts = new ArrayList<IFunction>();
        try {
            ArrayList<String> realConverts = new ArrayList<String>();
            boolean hasDefault = false;
            for (String convert : functionAry) {
                String[] ary;
                for (String tmp : ary = convert.split("\\,|\\;")) {
                    if (!StringUtil.isNotBlank(tmp)) continue;
                    if ("default".equals(tmp) || "defaults".equals(tmp)) {
                        hasDefault = true;
                        continue;
                    }
                    if (realConverts.contains(tmp)) continue;
                    realConverts.add(tmp);
                }
            }
            if (hasDefault) {
                for (String convert : functions) {
                    if (realConverts.contains(convert)) continue;
                    realConverts.add(convert);
                }
            }
            String functionName = null;
            HashSet<String> nameSet = new HashSet<String>();
            for (int i = 0; i < realConverts.size(); ++i) {
                functionName = ((String)realConverts.get(i)).trim();
                if (functionName.startsWith("org.sagacity.sqltoy")) {
                    functionName = funPackage.concat(functionName.substring(functionName.lastIndexOf(".") + 1));
                } else if (!functionName.contains(".") && functionNames.containsKey(functionName.toLowerCase())) {
                    functionName = funPackage.concat(functionNames.get(functionName.toLowerCase()));
                }
                String className = functionName.substring(functionName.lastIndexOf(".") + 1).toLowerCase();
                if (nameSet.contains(className)) continue;
                converts.add((IFunction)Class.forName(functionName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                nameSet.add(className);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        functionConverts = converts;
    }
}

