/*
 * Decompiled with CFR 0.152.
 */
package com.radcortez.flyway.test.junit;

import com.radcortez.flyway.test.annotation.DataSource;
import com.radcortez.flyway.test.annotation.FlywayTest;
import com.radcortez.flyway.test.junit.DataSourceInfo;
import com.radcortez.flyway.test.junit.DataSourceProvider;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.core.Flyway;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.util.AnnotationUtils;

public class FlywayExtension
implements TestInstancePostProcessor,
BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback {
    static final ExtensionContext.Namespace FLYWAY_EXTENSION = ExtensionContext.Namespace.create((Object[])new Object[]{new Object()});

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        context.getTestClass().flatMap(klass -> AnnotationUtils.findAnnotation((Class)klass, FlywayTest.class, (boolean)true)).ifPresent(flywayTest -> {
            ExtensionContext.Store store = context.getStore(FLYWAY_EXTENSION);
            store.put((Object)"flyway.flywayTest", flywayTest);
        });
    }

    public void beforeAll(ExtensionContext context) {
        Optional<FlywayTestConfiguration> configuration = this.getConfiguration(context);
        if (configuration.isEmpty()) {
            return;
        }
        Flyway flyway = this.flyway(configuration.get(), context);
        if (configuration.get().isClean()) {
            flyway.clean();
        }
        flyway.migrate();
    }

    public void beforeEach(ExtensionContext context) {
        this.getConfiguration(context).filter(FlywayTestConfiguration::isClean).map(configuration -> this.flyway((FlywayTestConfiguration)configuration, context)).ifPresent(Flyway::migrate);
    }

    public void afterEach(ExtensionContext context) {
        this.getConfiguration(context).filter(FlywayTestConfiguration::isClean).map(configuration -> this.flyway((FlywayTestConfiguration)configuration, context)).ifPresent(Flyway::clean);
    }

    private Flyway flyway(FlywayTestConfiguration configuration, ExtensionContext context) {
        String packageName = context.getRequiredTestClass().getName();
        ArrayList<String> locations = new ArrayList<String>(configuration.getLocations());
        locations.add("db/" + packageName.replaceAll("\\.", "/"));
        locations.add("db/migration");
        return Flyway.configure().dataSource(configuration.getDatasourceInfo().getUrl(), configuration.getDatasourceInfo().getUsername(), configuration.getDatasourceInfo().getPassword()).connectRetries(120).locations((String[])locations.toArray(String[]::new)).load();
    }

    private Optional<FlywayTestConfiguration> getConfiguration(ExtensionContext context) {
        List<FlywayTest> flywayAnnotations = this.findFlywayAnnotations(context);
        if (flywayAnnotations.isEmpty()) {
            return Optional.empty();
        }
        String url = flywayAnnotations.stream().map(FlywayTest::value).map(DataSource::url).filter(FlywayExtension::isNotEmpty).findFirst().orElse("");
        String username = flywayAnnotations.stream().map(FlywayTest::value).map(DataSource::username).filter(FlywayExtension::isNotEmpty).findFirst().orElse("");
        String password = flywayAnnotations.stream().map(FlywayTest::value).map(DataSource::password).filter(FlywayExtension::isNotEmpty).findFirst().orElse("");
        List<String> locations = flywayAnnotations.stream().map(FlywayTest::additionalLocations).flatMap(Stream::of).collect(Collectors.toList());
        Boolean clean = flywayAnnotations.stream().map(FlywayTest::clean).findFirst().orElse(true);
        DataSourceInfo datasourceInfo = flywayAnnotations.stream().map(FlywayTest::value).map(DataSource::value).map(FlywayExtension::newDatasourceProvider).filter(provider -> !(provider instanceof DataSource.DEFAULT)).map(provider -> provider.getDatasourceInfo(context)).findFirst().orElse(DataSourceInfo.config(url, username, password));
        if (datasourceInfo.getUrl() == null) {
            throw new IllegalStateException("No jdbc url provided.");
        }
        return Optional.of(FlywayTestConfiguration.flywayTestConfiguration(datasourceInfo, locations, clean));
    }

    private List<FlywayTest> findFlywayAnnotations(ExtensionContext context) {
        ArrayList<FlywayTest> flywayTestAnnotations = new ArrayList<FlywayTest>();
        context.getTestMethod().flatMap(klass -> AnnotationUtils.findAnnotation((AnnotatedElement)klass, FlywayTest.class)).ifPresent(flywayTestAnnotations::add);
        this.findFlywayAnnotation(context).ifPresent(flywayTestAnnotations::add);
        Optional parentContext = context.getParent();
        while (parentContext.isPresent()) {
            this.findFlywayAnnotation((ExtensionContext)parentContext.get()).ifPresent(flywayTestAnnotations::add);
            parentContext = ((ExtensionContext)parentContext.get()).getParent();
        }
        return flywayTestAnnotations;
    }

    private Optional<FlywayTest> findFlywayAnnotation(ExtensionContext context) {
        FlywayTest flywayTest = (FlywayTest)context.getStore(FLYWAY_EXTENSION).get((Object)"flyway.flywayTest", FlywayTest.class);
        if (flywayTest != null) {
            return Optional.of(flywayTest);
        }
        return context.getTestClass().flatMap(klass -> AnnotationUtils.findAnnotation((Class)klass, FlywayTest.class, (boolean)true));
    }

    private static DataSourceProvider newDatasourceProvider(Class<? extends DataSourceProvider> klass) {
        try {
            return klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean isNotEmpty(String s) {
        return !s.isEmpty();
    }

    private static class FlywayTestConfiguration {
        private DataSourceInfo datasourceInfo;
        private List<String> locations;
        private boolean clean;

        private FlywayTestConfiguration(DataSourceInfo datasourceInfo, List<String> locations, boolean clean) {
            this.datasourceInfo = datasourceInfo;
            this.locations = locations;
            this.clean = clean;
        }

        private static FlywayTestConfiguration flywayTestConfiguration(DataSourceInfo datasourceInfo, List<String> locations, boolean clean) {
            return new FlywayTestConfiguration(datasourceInfo, locations, clean);
        }

        DataSourceInfo getDatasourceInfo() {
            return this.datasourceInfo;
        }

        List<String> getLocations() {
            return this.locations;
        }

        boolean isClean() {
            return this.clean;
        }
    }
}

