/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen.support;

import com.google.common.collect.ImmutableList;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.codegen.support.Mapping;

public class RenameMapping
implements Mapping {
    private String fromSchema;
    private String fromTable;
    private String fromColumn;
    private String toSchema;
    private String toTable;
    private String toColumn;

    @Override
    public void apply(Configuration configuration) {
        if (this.fromSchema != null) {
            if (this.fromTable != null && this.fromColumn != null && this.toColumn != null) {
                configuration.registerColumnOverride(this.fromSchema, this.fromTable, this.fromColumn, this.toColumn);
            } else if (this.fromTable != null && this.toTable != null) {
                if (this.toSchema != null) {
                    configuration.registerTableOverride(this.fromSchema, this.fromTable, this.toSchema, this.toTable);
                } else {
                    configuration.registerTableOverride(this.fromSchema, this.fromTable, this.toTable);
                }
            } else if (this.toSchema != null) {
                configuration.registerSchemaOverride(this.fromSchema, this.toSchema);
            } else {
                this.insufficientArgs();
            }
        } else if (this.fromTable != null) {
            if (this.fromColumn != null && this.toColumn != null) {
                configuration.registerColumnOverride(this.fromTable, this.fromColumn, this.toColumn);
            } else if (this.toTable != null) {
                configuration.registerTableOverride(this.fromTable, this.toTable);
            } else {
                this.insufficientArgs();
            }
        } else {
            this.insufficientArgs();
        }
    }

    private void insufficientArgs() {
        throw new IllegalArgumentException("Insufficient args " + ImmutableList.of((Object)this.fromSchema, (Object)this.fromTable, (Object)this.fromColumn) + " to " + ImmutableList.of((Object)this.toSchema, (Object)this.toTable, (Object)this.toColumn));
    }

    public String getFromSchema() {
        return this.fromSchema;
    }

    public void setFromSchema(String fromSchema) {
        this.fromSchema = fromSchema;
    }

    public String getFromTable() {
        return this.fromTable;
    }

    public void setFromTable(String fromTable) {
        this.fromTable = fromTable;
    }

    public String getFromColumn() {
        return this.fromColumn;
    }

    public void setFromColumn(String fromColumn) {
        this.fromColumn = fromColumn;
    }

    public String getToSchema() {
        return this.toSchema;
    }

    public void setToSchema(String toSchema) {
        this.toSchema = toSchema;
    }

    public String getToTable() {
        return this.toTable;
    }

    public void setToTable(String toTable) {
        this.toTable = toTable;
    }

    public String getToColumn() {
        return this.toColumn;
    }

    public void setToColumn(String toColumn) {
        this.toColumn = toColumn;
    }
}

