/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen.ant;

import com.google.common.collect.Lists;
import com.mysema.codegen.model.SimpleType;
import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.Serializer;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.codegen.DefaultNamingStrategy;
import com.querydsl.sql.codegen.MetaDataExporter;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.CustomType;
import com.querydsl.sql.codegen.support.NumericMapping;
import com.querydsl.sql.codegen.support.RenameMapping;
import com.querydsl.sql.codegen.support.TypeMapping;
import com.querydsl.sql.types.Type;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntMetaDataExporter
extends Task {
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String namePrefix;
    private String nameSuffix;
    private String beanPrefix;
    private String beanSuffix;
    private String packageName;
    private String beanPackageName;
    private String schemaPattern;
    private String tableNamePattern;
    private String targetFolder;
    private String beansTargetFolder;
    private String namingStrategyClass = DefaultNamingStrategy.class.getName();
    private String beanSerializerClass = BeanSerializer.class.getName();
    private String serializerClass;
    private boolean exportBeans;
    private String[] beanInterfaces;
    private boolean beanAddToString;
    private boolean beanAddFullConstructor;
    private boolean beanPrintSupertype;
    private boolean innerClassesForKeys;
    private boolean validationAnnotations;
    private boolean columnAnnotations;
    private List<CustomType> customTypes = Lists.newArrayList();
    private boolean createScalaSources;
    private boolean schemaToPackage;
    private boolean lowerCase;
    private boolean exportTables = true;
    private boolean exportViews = true;
    private boolean exportAll;
    private boolean exportPrimaryKeys = true;
    private boolean exportForeignKeys = true;
    private boolean exportDirectForeignKeys = true;
    private boolean exportInverseForeignKeys = true;
    private String columnComparatorClass;
    private boolean spatial;
    private String tableTypesToExport;
    private String[] imports;
    private String sourceEncoding;
    private List<TypeMapping> typeMappings = Lists.newArrayList();
    private List<NumericMapping> numericMappings = Lists.newArrayList();
    private List<RenameMapping> renameMappings = Lists.newArrayList();

    public void execute() {
        if (this.targetFolder == null) {
            throw new BuildException("targetFolder is a mandatory property");
        }
        Connection dbConn = null;
        try {
            Class.forName(this.jdbcDriver).newInstance();
            dbConn = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            Configuration configuration = new Configuration(SQLTemplates.DEFAULT);
            MetaDataExporter exporter = new MetaDataExporter();
            if (this.namePrefix != null) {
                exporter.setNamePrefix(this.namePrefix);
            }
            if (this.nameSuffix != null) {
                exporter.setNameSuffix(this.nameSuffix);
            }
            if (this.beanPrefix != null) {
                exporter.setBeanPrefix(this.beanPrefix);
            }
            if (this.beanSuffix != null) {
                exporter.setBeanSuffix(this.beanSuffix);
            }
            if (this.beansTargetFolder != null) {
                exporter.setBeansTargetFolder(new File(this.beansTargetFolder));
            }
            exporter.setPackageName(this.packageName);
            exporter.setBeanPackageName(this.beanPackageName);
            exporter.setTargetFolder(new File(this.targetFolder));
            exporter.setNamingStrategy((NamingStrategy)Class.forName(this.namingStrategyClass).newInstance());
            exporter.setInnerClassesForKeys(this.innerClassesForKeys);
            exporter.setSchemaPattern(this.schemaPattern);
            exporter.setTableNamePattern(this.tableNamePattern);
            exporter.setColumnAnnotations(this.columnAnnotations);
            exporter.setValidationAnnotations(this.validationAnnotations);
            exporter.setSchemaToPackage(this.schemaToPackage);
            exporter.setLowerCase(this.lowerCase);
            exporter.setExportTables(this.exportTables);
            exporter.setExportViews(this.exportViews);
            exporter.setExportAll(this.exportAll);
            exporter.setTableTypesToExport(this.tableTypesToExport);
            exporter.setExportPrimaryKeys(this.exportPrimaryKeys);
            exporter.setExportForeignKeys(this.exportForeignKeys);
            exporter.setExportDirectForeignKeys(this.exportDirectForeignKeys);
            exporter.setExportInverseForeignKeys(this.exportInverseForeignKeys);
            exporter.setSpatial(this.spatial);
            if (this.imports != null && this.imports.length > 0) {
                exporter.setImports(this.imports);
            }
            if (this.exportBeans) {
                BeanSerializer serializer = (BeanSerializer)Class.forName(this.beanSerializerClass).newInstance();
                if (this.beanInterfaces != null) {
                    for (String iface : this.beanInterfaces) {
                        int sepIndex = iface.lastIndexOf(46);
                        if (sepIndex < 0) {
                            serializer.addInterface((com.mysema.codegen.model.Type)new SimpleType(iface));
                            continue;
                        }
                        String packageName = iface.substring(0, sepIndex);
                        String simpleName = iface.substring(sepIndex + 1);
                        serializer.addInterface((com.mysema.codegen.model.Type)new SimpleType(iface, packageName, simpleName, new com.mysema.codegen.model.Type[0]));
                    }
                }
                serializer.setAddFullConstructor(this.beanAddFullConstructor);
                serializer.setAddToString(this.beanAddToString);
                serializer.setPrintSupertype(this.beanPrintSupertype);
                exporter.setBeanSerializer((Serializer)serializer);
            }
            if (this.sourceEncoding != null) {
                exporter.setSourceEncoding(this.sourceEncoding);
            }
            if (this.customTypes != null) {
                for (CustomType customType : this.customTypes) {
                    configuration.register((Type)Class.forName(customType.getClassName()).newInstance());
                }
            }
            if (this.typeMappings != null) {
                for (TypeMapping typeMapping : this.typeMappings) {
                    typeMapping.apply(configuration);
                }
            }
            if (this.numericMappings != null) {
                for (NumericMapping numericMapping : this.numericMappings) {
                    numericMapping.apply(configuration);
                }
            }
            if (this.renameMappings != null) {
                for (RenameMapping renameMapping : this.renameMappings) {
                    renameMapping.apply(configuration);
                }
            }
            if (this.columnComparatorClass != null) {
                exporter.setColumnComparatorClass(Class.forName(this.columnComparatorClass).asSubclass(Comparator.class));
            }
            exporter.setConfiguration(configuration);
            exporter.export(dbConn.getMetaData());
        }
        catch (RuntimeException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException e2) {
                    throw new BuildException((Throwable)e2);
                }
            }
        }
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public String getBeanPrefix() {
        return this.beanPrefix;
    }

    public void setBeanPrefix(String beanPrefix) {
        this.beanPrefix = beanPrefix;
    }

    public String getBeanSuffix() {
        return this.beanSuffix;
    }

    public void setBeanSuffix(String beanSuffix) {
        this.beanSuffix = beanSuffix;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getBeanPackageName() {
        return this.beanPackageName;
    }

    public void setBeanPackageName(String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public String getNamingStrategyClass() {
        return this.namingStrategyClass;
    }

    public void setNamingStrategyClass(String namingStrategyClass) {
        this.namingStrategyClass = namingStrategyClass;
    }

    public String getBeanSerializerClass() {
        return this.beanSerializerClass;
    }

    public void setBeanSerializerClass(String beanSerializerClass) {
        this.beanSerializerClass = beanSerializerClass;
    }

    public String getSerializerClass() {
        return this.serializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public boolean isExportBeans() {
        return this.exportBeans;
    }

    public void setExportBeans(boolean exportBeans) {
        this.exportBeans = exportBeans;
    }

    public String[] getBeanInterfaces() {
        return this.beanInterfaces;
    }

    public void setBeanInterfaces(String[] beanInterfaces) {
        this.beanInterfaces = beanInterfaces;
    }

    public boolean isBeanAddToString() {
        return this.beanAddToString;
    }

    public void setBeanAddToString(boolean beanAddToString) {
        this.beanAddToString = beanAddToString;
    }

    public boolean isBeanAddFullConstructor() {
        return this.beanAddFullConstructor;
    }

    public void setBeanAddFullConstructor(boolean beanAddFullConstructor) {
        this.beanAddFullConstructor = beanAddFullConstructor;
    }

    public boolean isBeanPrintSupertype() {
        return this.beanPrintSupertype;
    }

    public void setBeanPrintSupertype(boolean beanPrintSupertype) {
        this.beanPrintSupertype = beanPrintSupertype;
    }

    public boolean isInnerClassesForKeys() {
        return this.innerClassesForKeys;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.innerClassesForKeys = innerClassesForKeys;
    }

    public boolean isValidationAnnotations() {
        return this.validationAnnotations;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public boolean isColumnAnnotations() {
        return this.columnAnnotations;
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void addCustomType(CustomType customType) {
        this.customTypes.add(customType);
    }

    public String[] getCustomTypes() {
        String[] customTypes = new String[this.customTypes.size()];
        for (int i = 0; i < this.customTypes.size(); ++i) {
            CustomType customType = this.customTypes.get(i);
            customTypes[i] = customType.getClassName();
        }
        return customTypes;
    }

    public void setCustomTypes(String[] strings) {
        this.customTypes.clear();
        for (String string : strings) {
            CustomType customType = new CustomType();
            customType.setClassName(string);
            this.customTypes.add(customType);
        }
    }

    public boolean isCreateScalaSources() {
        return this.createScalaSources;
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public boolean isSchemaToPackage() {
        return this.schemaToPackage;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public boolean isExportTables() {
        return this.exportTables;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    public boolean isExportViews() {
        return this.exportViews;
    }

    public void setExportViews(boolean exportViews) {
        this.exportViews = exportViews;
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public boolean isExportPrimaryKeys() {
        return this.exportPrimaryKeys;
    }

    public void setExportPrimaryKeys(boolean exportPrimaryKeys) {
        this.exportPrimaryKeys = exportPrimaryKeys;
    }

    public boolean isExportForeignKeys() {
        return this.exportForeignKeys;
    }

    public boolean isExportDirectForeignKeys() {
        return this.exportDirectForeignKeys;
    }

    public void setExportDirectForeignKeys(boolean exportDirectForeignKeys) {
        this.exportDirectForeignKeys = exportDirectForeignKeys;
    }

    public boolean isExportInverseForeignKeys() {
        return this.exportInverseForeignKeys;
    }

    public void setExportInverseForeignKeys(boolean exportInverseForeignKeys) {
        this.exportInverseForeignKeys = exportInverseForeignKeys;
    }

    public void setExportForeignKeys(boolean exportForeignKeys) {
        this.exportForeignKeys = exportForeignKeys;
    }

    public String getColumnComparatorClass() {
        return this.columnComparatorClass;
    }

    public void setColumnComparatorClass(String columnComparatorClass) {
        this.columnComparatorClass = columnComparatorClass;
    }

    public boolean isSpatial() {
        return this.spatial;
    }

    public void setSpatial(boolean spatial) {
        this.spatial = spatial;
    }

    public String getTableTypesToExport() {
        return this.tableTypesToExport;
    }

    public void setTableTypesToExport(String tableTypesToExport) {
        this.tableTypesToExport = tableTypesToExport;
    }

    public String[] getImports() {
        return this.imports;
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public String getBeansTargetFolder() {
        return this.beansTargetFolder;
    }

    public void setBeansTargetFolder(String beansTargetFolder) {
        this.beansTargetFolder = beansTargetFolder;
    }

    public void addTypeMapping(TypeMapping mapping) {
        this.typeMappings.add(mapping);
    }

    public void addNumericMapping(NumericMapping mapping) {
        this.numericMappings.add(mapping);
    }

    public void addRenameMapping(RenameMapping mapping) {
        this.renameMappings.add(mapping);
    }
}

