/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.google.common.collect.ImmutableList;
import com.querydsl.codegen.EntityType;
import com.querydsl.sql.codegen.AbstractNamingStrategy;
import java.util.Locale;

public class DefaultNamingStrategy
extends AbstractNamingStrategy {
    public DefaultNamingStrategy() {
        this.reservedSuffix = "Col";
    }

    @Override
    public String getClassName(String tableName) {
        String className = tableName.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.toCamelCase(tableName.substring(1));
        return this.normalizeJavaName(className);
    }

    @Override
    public String getDefaultAlias(EntityType entityType) {
        return entityType.getData().get("table").toString();
    }

    @Override
    public String getDefaultVariableName(EntityType entityType) {
        String variable = this.escape(entityType, this.toCamelCase(entityType.getData().get("table").toString()));
        return this.normalizeJavaName(variable);
    }

    @Override
    public String getForeignKeysVariable(EntityType entityType) {
        String variable = this.escape(entityType, this.foreignKeysVariable);
        return this.normalizeJavaName(variable);
    }

    @Override
    public String getPrimaryKeysVariable(EntityType entityType) {
        String variable = this.escape(entityType, this.primaryKeysVariable);
        return this.normalizeJavaName(variable);
    }

    @Override
    public String getPropertyName(String columnName, EntityType entityType) {
        String normalized = this.normalizeJavaName(columnName);
        return this.normalizeJavaName(normalized.substring(0, 1).toLowerCase(Locale.ENGLISH) + this.toCamelCase(normalized.substring(1)));
    }

    @Override
    public String getPropertyNameForForeignKey(String fkName, EntityType entityType) {
        if (fkName.toLowerCase().startsWith("fk_")) {
            fkName = fkName.substring(3) + "_" + fkName.substring(0, 2);
        }
        String propertyName = this.escape(entityType, this.getPropertyName(fkName, entityType));
        return this.normalizeJavaName(propertyName);
    }

    @Override
    public String getPropertyNameForInverseForeignKey(String fkName, EntityType entityType) {
        String propertyName = "_" + this.getPropertyNameForForeignKey(fkName, entityType);
        return this.normalizeJavaName(propertyName);
    }

    @Override
    public String getPropertyNameForPrimaryKey(String pkName, EntityType entityType) {
        if (pkName.toLowerCase().startsWith("pk_")) {
            pkName = pkName.substring(3) + "_" + pkName.substring(0, 2);
        }
        String propertyName = this.getPropertyName(pkName, entityType);
        for (String candidate : ImmutableList.of((Object)propertyName, (Object)(propertyName + "Pk"))) {
            if (entityType.getEscapedPropertyNames().contains(candidate)) continue;
            return this.normalizeJavaName(candidate);
        }
        return this.normalizeJavaName(this.escape(entityType, propertyName));
    }

    protected String toCamelCase(String str) {
        boolean toLower = str.toUpperCase().equals(str);
        StringBuilder builder = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (i < str.length() - 1 && (str.charAt(i) == '_' || str.charAt(i) == ' ')) {
                if (++i >= str.length()) continue;
                builder.append(Character.toUpperCase(str.charAt(i)));
                continue;
            }
            if (toLower) {
                builder.append(Character.toLowerCase(str.charAt(i)));
                continue;
            }
            builder.append(str.charAt(i));
        }
        return builder.toString();
    }
}

