/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;

@FunctionalInterface
public interface ThrowingRunnable<E extends Exception> {
    public void run() throws E;

    public static Runnable unchecked(ThrowingRunnable<?> runnable) {
        return Objects.requireNonNull(runnable).unchecked();
    }

    public static Runnable sneaky(ThrowingRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }

    default public Runnable unchecked() {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }
}

