/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.graphml;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.graph.graphml.OGraphMLImportStrategy;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class OGraphMLReader {
    private static final String LABELS = "labels";
    private final OrientBaseGraph graph;
    private int vertexLabelIndex = 0;
    private String vertexIdKey = "id";
    private String edgeIdKey = null;
    private String edgeLabelKey = "label";
    private boolean storeVertexIds = false;
    private int batchSize = 1000;
    private Map<String, OGraphMLImportStrategy> vertexPropsStrategy = new HashMap<String, OGraphMLImportStrategy>();
    private Map<String, OGraphMLImportStrategy> edgePropsStrategy = new HashMap<String, OGraphMLImportStrategy>();

    public OGraphMLReader(OrientBaseGraph graph) {
        this.graph = graph;
    }

    public OGraphMLReader defineVertexAttributeStrategy(String iAttributeName, OGraphMLImportStrategy iStrategy) {
        this.vertexPropsStrategy.put(iAttributeName, iStrategy);
        return this;
    }

    public OGraphMLReader defineEdgeAttributeStrategy(String iAttributeName, OGraphMLImportStrategy iStrategy) {
        this.edgePropsStrategy.put(iAttributeName, iStrategy);
        return this;
    }

    public void inputGraph(Graph inputGraph, InputStream graphMLInputStream) throws IOException {
        this.inputGraph(inputGraph, graphMLInputStream, this.batchSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public void inputGraph(Graph inputGraph, String filename) throws IOException {
        this.inputGraph(inputGraph, filename, this.batchSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OGraphMLReader inputGraph(Graph inputGraph, String filename, int bufferSize, String vertexIdKey, String edgeIdKey, String edgeLabelKey) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        try {
            OGraphMLReader oGraphMLReader = this.inputGraph(inputGraph, fis, bufferSize, vertexIdKey, edgeIdKey, edgeLabelKey);
            return oGraphMLReader;
        }
        finally {
            fis.close();
        }
    }

    public OGraphMLReader inputGraph(Graph inputGraph, InputStream graphMLInputStream, int bufferSize, String vertexIdKey, String edgeIdKey, String edgeLabelKey) throws IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(graphMLInputStream);
            OrientBaseGraph graph = (OrientBaseGraph)inputGraph;
            if (this.storeVertexIds) {
                graph.setSaveOriginalIds(this.storeVertexIds);
            }
            HashMap<String, String> keyIdMap = new HashMap<String, String>();
            HashMap<String, String> keyTypesMaps = new HashMap<String, String>();
            HashMap<String, ORID> vertexMappedIdMap = new HashMap<String, ORID>();
            String vertexId = null;
            HashMap<String, Object> vertexProps = null;
            boolean inVertex = false;
            String edgeId = null;
            String edgeLabel = null;
            String vertexLabel = null;
            Vertex[] edgeEndVertices = null;
            HashMap<String, Object> edgeProps = null;
            boolean inEdge = false;
            int bufferCounter = 0;
            while (reader.hasNext()) {
                String elementName;
                Integer eventType = reader.next();
                if (eventType.equals(1)) {
                    String attributeName;
                    elementName = reader.getName().getLocalPart();
                    if (elementName.equals("key")) {
                        String id = reader.getAttributeValue(null, "id");
                        attributeName = reader.getAttributeValue(null, "attr.name");
                        String attributeType = reader.getAttributeValue(null, "attr.type");
                        keyIdMap.put(id, attributeName);
                        keyTypesMaps.put(id, attributeType);
                    } else if (elementName.equals("node")) {
                        vertexId = reader.getAttributeValue(null, "id");
                        vertexLabel = reader.getAttributeValue(null, LABELS);
                        if (vertexLabel != null) {
                            if (vertexLabel.startsWith(":")) {
                                vertexLabel = vertexLabel.substring(1);
                            }
                            String[] vertexLabels = vertexLabel.split(":");
                            vertexLabel = vertexId + ",class:" + vertexLabels[this.vertexLabelIndex];
                        } else {
                            vertexLabel = vertexId;
                        }
                        inVertex = true;
                        vertexProps = new HashMap<String, Object>();
                    } else if (elementName.equals("edge")) {
                        edgeId = reader.getAttributeValue(null, "id");
                        edgeLabel = reader.getAttributeValue(null, "label");
                        edgeLabel = edgeLabel == null ? "_default" : edgeLabel;
                        String[] vertexIds = new String[]{reader.getAttributeValue(null, "source"), reader.getAttributeValue(null, "target")};
                        edgeEndVertices = new Vertex[2];
                        for (int i = 0; i < 2; ++i) {
                            if (vertexIdKey == null) {
                                edgeEndVertices[i] = null;
                            } else {
                                Object vId = vertexMappedIdMap.get(vertexIds[i]);
                                OrientVertex orientVertex = edgeEndVertices[i] = vId != null ? graph.getVertex(vId) : null;
                            }
                            if (null != edgeEndVertices[i]) continue;
                            edgeEndVertices[i] = graph.addVertex(vertexLabel);
                            if (vertexIdKey != null) {
                                this.mapId(vertexMappedIdMap, vertexIds[i], (ORID)edgeEndVertices[i].getId());
                            }
                            ++bufferCounter;
                        }
                        inEdge = true;
                        vertexLabel = null;
                        edgeProps = new HashMap<String, Object>();
                    } else if (elementName.equals("data")) {
                        OGraphMLImportStrategy strategy;
                        Object attrValue;
                        String key = reader.getAttributeValue(null, "key");
                        attributeName = (String)keyIdMap.get(key);
                        if (attributeName == null) {
                            attributeName = key;
                        }
                        String value = reader.getElementText();
                        if (inVertex) {
                            if (vertexIdKey != null && key.equals(vertexIdKey)) {
                                vertexId = value;
                            } else if (!attributeName.equalsIgnoreCase(LABELS)) {
                                attrValue = this.typeCastValue(key, value, keyTypesMaps);
                                strategy = this.vertexPropsStrategy.get(attributeName);
                                if (strategy != null) {
                                    attributeName = strategy.transformAttribute(attributeName, attrValue);
                                }
                                if (attributeName != null) {
                                    vertexProps.put(attributeName, attrValue);
                                }
                            }
                        } else if (inEdge) {
                            if (edgeLabelKey != null && key.equals(edgeLabelKey)) {
                                edgeLabel = value;
                            } else if (edgeIdKey != null && key.equals(edgeIdKey)) {
                                edgeId = value;
                            } else {
                                attrValue = this.typeCastValue(key, value, keyTypesMaps);
                                strategy = this.edgePropsStrategy.get(attributeName);
                                if (strategy != null) {
                                    attributeName = strategy.transformAttribute(attributeName, attrValue);
                                }
                                if (attributeName != null) {
                                    edgeProps.put(attributeName, attrValue);
                                }
                            }
                        }
                    }
                } else if (eventType.equals(2)) {
                    elementName = reader.getName().getLocalPart();
                    if (elementName.equals("node")) {
                        OrientVertex v;
                        ORID currentVertex = null;
                        if (vertexIdKey != null) {
                            currentVertex = (ORID)vertexMappedIdMap.get(vertexId);
                        }
                        if (currentVertex == null) {
                            v = graph.addVertex((Object)vertexLabel, vertexProps);
                            if (vertexIdKey != null) {
                                this.mapId(vertexMappedIdMap, vertexId, v.getIdentity());
                            }
                            ++bufferCounter;
                        } else {
                            v = graph.getVertex(currentVertex);
                            v.setProperties(vertexProps);
                        }
                        vertexId = null;
                        vertexLabel = null;
                        vertexProps = null;
                        inVertex = false;
                    } else if (elementName.equals("edge")) {
                        OrientEdge currentEdge = ((OrientVertex)edgeEndVertices[0]).addEdge(null, (OrientVertex)edgeEndVertices[1], edgeLabel, null, edgeProps);
                        ++bufferCounter;
                        edgeId = null;
                        edgeLabel = null;
                        edgeEndVertices = null;
                        edgeProps = null;
                        inEdge = false;
                    }
                }
                if (bufferCounter <= bufferSize) continue;
                graph.commit();
                bufferCounter = 0;
            }
            reader.close();
            graph.commit();
        }
        catch (Exception xse) {
            throw OException.wrapException((OException)new ODatabaseImportException("Error on importing GraphML"), (Throwable)xse);
        }
        return this;
    }

    public int getVertexLabelIndex() {
        return this.vertexLabelIndex;
    }

    public void setVertexLabelIndex(int vertexLabelIndex) {
        this.vertexLabelIndex = vertexLabelIndex;
    }

    public void setVertexIdKey(String vertexIdKey) {
        this.vertexIdKey = vertexIdKey;
    }

    public void setEdgeIdKey(String edgeIdKey) {
        this.edgeIdKey = edgeIdKey;
    }

    public void setEdgeLabelKey(String edgeLabelKey) {
        this.edgeLabelKey = edgeLabelKey;
    }

    public OGraphMLReader inputGraph(InputStream graphMLInputStream) throws IOException {
        return this.inputGraph((Graph)this.graph, graphMLInputStream, this.batchSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public OGraphMLReader inputGraph(String filename) throws IOException {
        return this.inputGraph((Graph)this.graph, filename, this.batchSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public OGraphMLReader inputGraph(InputStream graphMLInputStream, int bufferSize) throws IOException {
        return this.inputGraph((Graph)this.graph, graphMLInputStream, bufferSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public OGraphMLReader inputGraph(String filename, int bufferSize) throws IOException {
        return this.inputGraph((Graph)this.graph, filename, bufferSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public boolean isStoreVertexIds() {
        return this.storeVertexIds;
    }

    public void setStoreVertexIds(boolean storeVertexIds) {
        this.storeVertexIds = storeVertexIds;
    }

    public OGraphMLReader setOptions(Map<String, List<String>> opts) {
        for (Map.Entry<String, List<String>> opt : opts.entrySet()) {
            if (opt.getKey().equalsIgnoreCase("storeVertexIds")) {
                this.storeVertexIds = Boolean.parseBoolean(opt.getValue().get(0));
                continue;
            }
            if (!opt.getKey().equalsIgnoreCase("batchSize")) continue;
            this.batchSize = Integer.parseInt(opt.getValue().get(0));
        }
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected void mapId(Map<String, ORID> vertexMappedIdMap, String vertexId, ORID rid) {
        if (vertexMappedIdMap.containsKey(vertexId)) {
            throw new IllegalArgumentException("Vertex with id '" + vertexId + "' has been already loaded");
        }
        vertexMappedIdMap.put(vertexId, rid);
    }

    private Object typeCastValue(String key, String value, Map<String, String> keyTypes) {
        String type = keyTypes.get(key);
        if (null == type || type.equals("string")) {
            return value;
        }
        if (type.equals("float")) {
            return Float.valueOf(value);
        }
        if (type.equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.equals("double")) {
            return Double.valueOf(value);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.equals("long")) {
            return Long.valueOf(value);
        }
        return value;
    }
}

