/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.intent.OIntent;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.concurrent.atomic.AtomicBoolean;

public class OrientGraphFactory
extends OrientConfigurableGraph {
    protected final String url;
    protected final String user;
    protected final String password;
    protected volatile OPartitionedDatabasePool pool;
    protected OIntent intent;
    protected AtomicBoolean used = new AtomicBoolean(false);

    public OrientGraphFactory(String iURL) {
        this(iURL, "admin", "admin");
    }

    public OrientGraphFactory(String iURL, String iUser, String iPassword) {
        this.url = iURL;
        this.user = iUser;
        this.password = iPassword;
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
        this.pool = null;
    }

    public void drop() {
        this.getDatabase(false, true).drop();
    }

    public OrientGraph getTx() {
        OrientGraph g = this.pool == null ? new OrientGraph(this.getDatabase(), this.user, this.password, this.settings) : new OrientGraph(this.pool, this.settings);
        this.initGraph(g);
        return g;
    }

    public OrientGraphNoTx getNoTx() {
        OrientGraphNoTx g = this.pool == null ? new OrientGraphNoTx(this.getDatabase(), this.user, this.password, this.settings) : new OrientGraphNoTx(this.pool, this.settings);
        this.initGraph(g);
        return g;
    }

    public ODatabaseDocumentTx getDatabase() {
        return this.getDatabase(true, true);
    }

    public ODatabaseDocumentTx getDatabase(boolean iCreate, boolean iOpen) {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(this.url);
        if (!db.getURL().startsWith("remote:") && !db.exists()) {
            if (iCreate) {
                db.create();
            } else if (iOpen) {
                throw new ODatabaseException("Database '" + this.url + "' not found");
            }
        } else if (iOpen) {
            db.open(this.user, this.password);
        }
        return db;
    }

    public boolean exists() {
        ODatabaseDocumentTx db = this.getDatabase(false, false);
        try {
            boolean bl = db.exists();
            return bl;
        }
        finally {
            db.close();
        }
    }

    public OrientGraphFactory setupPool(int iMin, int iMax) {
        this.pool = new OPartitionedDatabasePool(this.url, this.user, this.password, 64, iMax).setAutoCreate(true);
        return this;
    }

    public int getAvailableInstancesInPool() {
        if (this.pool != null) {
            return this.pool.getAvailableConnections();
        }
        return 0;
    }

    public int getCreatedInstancesInPool() {
        if (this.pool != null) {
            return this.pool.getCreatedInstances();
        }
        return 0;
    }

    @Override
    public void declareIntent(OIntent iIntent) {
        this.intent = iIntent;
    }

    protected void initGraph(OrientBaseGraph g) {
        if (this.used.compareAndSet(false, true)) {
            ODatabaseDocumentTx db = g.getRawGraph();
            boolean txActive = db.getTransaction().isActive();
            if (txActive) {
                db.commit();
            }
            OrientBaseGraph.checkForGraphSchema(db);
            if (txActive) {
                db.begin();
                db.getTransaction().setUsingLog(this.settings.isUseLog());
            }
        }
        if (this.intent != null) {
            g.declareIntent(this.intent.copy());
        }
    }
}

