/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRetryAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class OCommandExecutorSQLDeleteEdge
extends OCommandExecutorSQLRetryAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE EDGE";
    private static final String KEYWORD_BATCH = "BATCH";
    private List<ORecordId> rids;
    private String fromExpr;
    private String toExpr;
    private int removed = 0;
    private OCommandRequest query;
    private OSQLFilter compiledFilter;
    private AtomicReference<OrientBaseGraph> currentGraph = new AtomicReference();
    private String label;
    private OModifiableBoolean shutdownFlag = new OModifiableBoolean();
    private boolean txAlreadyBegun;
    private int batch = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLDeleteEdge parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            String[] stringArray;
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword(new String[]{"DELETE"});
            this.parserRequiredKeyword(new String[]{"EDGE"});
            OrientEdgeType clazz = null;
            String where = null;
            String temp = this.parseOptionalWord(true, new String[0]);
            String originalTemp = null;
            if (temp != null && !this.parserIsEnded()) {
                originalTemp = this.parserText.substring(this.parserGetPreviousPosition(), this.parserGetCurrentPosition()).trim();
            }
            OModifiableBoolean shutdownFlag = new OModifiableBoolean();
            ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.INSTANCE.get();
            OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(false, shutdownFlag);
            try {
                while (temp != null) {
                    if (temp.equals("FROM")) {
                        this.fromExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                        if (this.rids != null) {
                            this.throwSyntaxErrorException("FROM '" + this.fromExpr + "' is not allowed when specify a RIDs (" + this.rids + ")");
                        }
                    } else if (temp.equals("TO")) {
                        this.toExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                        if (this.rids != null) {
                            this.throwSyntaxErrorException("TO '" + this.toExpr + "' is not allowed when specify a RID (" + this.rids + ")");
                        }
                    } else if (temp.startsWith("#")) {
                        this.rids = new ArrayList<ORecordId>();
                        this.rids.add(new ORecordId(temp));
                        if (this.fromExpr != null || this.toExpr != null) {
                            this.throwSyntaxErrorException("Specifying the RID " + this.rids + " is not allowed with FROM/TO");
                        }
                    } else if (temp.startsWith("[") && temp.endsWith("]")) {
                        temp = temp.substring(1, temp.length() - 1);
                        this.rids = new ArrayList<ORecordId>();
                        for (String rid : temp.split(",")) {
                            if (!(rid = rid.trim()).startsWith("#")) {
                                this.throwSyntaxErrorException("Not a valid RID: " + rid);
                            }
                            this.rids.add(new ORecordId(rid));
                        }
                    } else {
                        if (temp.equals("WHERE")) {
                            if (clazz == null) {
                                clazz = graph.getEdgeType("E");
                            }
                            where = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetCurrentPosition()) : "";
                            this.compiledFilter = OSQLEngine.getInstance().parseCondition(where, this.getContext(), "WHERE");
                            break;
                        }
                        if (temp.equals("RETRY")) {
                            this.parseRetry();
                        } else if (temp.equals(KEYWORD_BATCH)) {
                            temp = this.parserNextWord(true);
                            if (temp != null) {
                                this.batch = Integer.parseInt(temp);
                            }
                        } else if (temp.equals("LIMIT")) {
                            temp = this.parserNextWord(true);
                            if (temp != null) {
                                this.limit = Integer.parseInt(temp);
                            }
                        } else if (temp.length() > 0) {
                            this.label = originalTemp;
                            clazz = graph.getEdgeType(temp);
                            if (clazz == null) {
                                throw new OCommandSQLParsingException("Class '" + temp + "' was not found");
                            }
                        }
                    }
                    temp = this.parseOptionalWord(true, new String[0]);
                    if (!this.parserIsEnded()) continue;
                }
                where = where == null ? (this.limit > -1 ? " LIMIT " + this.limit : "") : " WHERE " + where;
                if (this.fromExpr == null && this.toExpr == null && this.rids == null) {
                    this.query = clazz == null ? graph.getRawGraph().command((OCommandRequest)new OSQLAsynchQuery("select from E" + where, (OCommandResultListener)this)) : graph.getRawGraph().command((OCommandRequest)new OSQLAsynchQuery("select from " + clazz.getName() + where, (OCommandResultListener)this));
                }
                stringArray = this;
            }
            catch (Throwable throwable) {
                if (shutdownFlag.getValue()) {
                    graph.shutdown(false, false);
                }
                ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
                throw throwable;
            }
            if (shutdownFlag.getValue()) {
                graph.shutdown(false, false);
            }
            ODatabaseRecordThreadLocal.INSTANCE.set(curDb);
            return stringArray;
        }
        finally {
            textRequest.setText(originalQuery);
        }
    }

    public Object execute(final Map<Object, Object> iArgs) {
        if (this.fromExpr == null && this.toExpr == null && this.rids == null && this.query == null && this.compiledFilter == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        this.txAlreadyBegun = OCommandExecutorSQLDeleteEdge.getDatabase().getTransaction().isActive();
        if (this.rids != null) {
            OGraphCommandExecutorSQLFactory.runInConfiguredTxMode(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                @Override
                public Object call(OrientBaseGraph graph) {
                    for (ORecordId rid : OCommandExecutorSQLDeleteEdge.this.rids) {
                        OrientEdge e = graph.getEdge(rid);
                        if (e == null) continue;
                        e.remove();
                        OCommandExecutorSQLDeleteEdge.this.removed++;
                    }
                    return null;
                }
            });
            this.end();
        } else {
            final ArrayList edges = new ArrayList();
            if (this.query == null) {
                OGraphCommandExecutorSQLFactory.runInConfiguredTxMode(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                    @Override
                    public Object call(OrientBaseGraph graph) {
                        OrientVertex v;
                        Set fromIds = null;
                        if (OCommandExecutorSQLDeleteEdge.this.fromExpr != null) {
                            fromIds = OSQLEngine.getInstance().parseRIDTarget((ODatabaseDocument)graph.getRawGraph(), OCommandExecutorSQLDeleteEdge.this.fromExpr, OCommandExecutorSQLDeleteEdge.this.context, iArgs);
                        }
                        Set toIds = null;
                        if (OCommandExecutorSQLDeleteEdge.this.toExpr != null) {
                            toIds = OSQLEngine.getInstance().parseRIDTarget((ODatabaseDocument)graph.getRawGraph(), OCommandExecutorSQLDeleteEdge.this.toExpr, OCommandExecutorSQLDeleteEdge.this.context, iArgs);
                        }
                        if (fromIds != null && toIds != null) {
                            for (OIdentifiable fromId : fromIds) {
                                v = graph.getVertex(fromId);
                                if (v == null) continue;
                                for (Edge e : v.getEdges(Direction.OUT, new String[0])) {
                                    OIdentifiable inV;
                                    if (OCommandExecutorSQLDeleteEdge.this.label != null && !OCommandExecutorSQLDeleteEdge.this.label.equals(e.getLabel()) || (inV = ((OrientEdge)e).getInVertex()) == null || !toIds.contains(inV.getIdentity())) continue;
                                    edges.add((OrientEdge)e);
                                }
                            }
                        } else if (fromIds != null) {
                            for (OIdentifiable fromId : fromIds) {
                                v = graph.getVertex(fromId);
                                if (v == null) continue;
                                for (Edge e : v.getEdges(Direction.OUT, new String[0])) {
                                    if (OCommandExecutorSQLDeleteEdge.this.label != null && !OCommandExecutorSQLDeleteEdge.this.label.equals(e.getLabel())) continue;
                                    edges.add((OrientEdge)e);
                                }
                            }
                        } else if (toIds != null) {
                            for (OIdentifiable toId : toIds) {
                                v = graph.getVertex(toId);
                                if (v == null) continue;
                                for (Edge e : v.getEdges(Direction.IN, new String[0])) {
                                    if (OCommandExecutorSQLDeleteEdge.this.label != null && !OCommandExecutorSQLDeleteEdge.this.label.equals(e.getLabel())) continue;
                                    edges.add((OrientEdge)e);
                                }
                            }
                        } else {
                            throw new OCommandExecutionException("Invalid target: " + toIds);
                        }
                        if (OCommandExecutorSQLDeleteEdge.this.compiledFilter != null) {
                            Iterator it = edges.iterator();
                            while (it.hasNext()) {
                                OrientEdge edge = (OrientEdge)it.next();
                                if (((Boolean)OCommandExecutorSQLDeleteEdge.this.compiledFilter.evaluate((OIdentifiable)edge.getRecord(), null, OCommandExecutorSQLDeleteEdge.this.context)).booleanValue()) continue;
                                it.remove();
                            }
                        }
                        OCommandExecutorSQLDeleteEdge.this.removed = edges.size();
                        for (OrientEdge edge : edges) {
                            edge.remove();
                        }
                        return null;
                    }
                });
                this.end();
            } else {
                OGraphCommandExecutorSQLFactory.runInConfiguredTxMode(new OGraphCommandExecutorSQLFactory.GraphCallBack<OrientGraph>(){

                    @Override
                    public OrientGraph call(OrientBaseGraph iGraph) {
                        OCommandExecutorSQLDeleteEdge.this.currentGraph.set(iGraph);
                        OCommandExecutorSQLDeleteEdge.this.query.setContext(OCommandExecutorSQLDeleteEdge.this.getContext());
                        OCommandExecutorSQLDeleteEdge.this.query.execute(new Object[]{iArgs});
                        return null;
                    }
                });
            }
        }
        return this.removed;
    }

    public boolean result(Object iRecord) {
        OrientBaseGraph g;
        OrientEdge e;
        OIdentifiable id = (OIdentifiable)iRecord;
        if (this.compiledFilter != null && !((Boolean)this.compiledFilter.evaluate((OIdentifiable)id.getRecord(), null, this.context)).booleanValue()) {
            return true;
        }
        if (id.getIdentity().isValid() && (e = (g = this.currentGraph.get()).getEdge(id)) != null) {
            e.remove();
            if (!this.txAlreadyBegun && this.batch > 0 && (this.removed + 1) % this.batch == 0 && g instanceof OrientGraph) {
                g.commit();
                ((OrientGraph)g).begin();
            }
            ++this.removed;
        }
        return true;
    }

    public String getSyntax() {
        return "DELETE EDGE <rid>|FROM <rid>|TO <rid>|<[<class>] [WHERE <conditions>]> [BATCH <batch-size>]";
    }

    public void end() {
        OrientBaseGraph g = this.currentGraph.get();
        if (g != null && !this.txAlreadyBegun) {
            g.commit();
            if (this.shutdownFlag.getValue()) {
                g.shutdown(false, false);
            }
        }
    }

    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return this.getDistributedExecutionMode() == OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL ? OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS : OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE;
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return this.query != null && !OCommandExecutorSQLDeleteEdge.getDatabase().getTransaction().isActive() ? OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE : OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }
}

