/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractTransformer;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;

public class OVertexTransformer
extends OAbstractTransformer {
    private String vertexClass;
    private boolean skipDuplicates = false;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + "," + "{class:{optional:true,description:'Vertex class name to assign. Default is " + "V" + "'}}" + ",skipDuplicates:{optional:true,description:'Vertices with duplicate keys are skipped', default:false}" + "]" + ",input:['OrientVertex','ODocument'],output:'OrientVertex'}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("class")) {
            this.vertexClass = (String)this.resolve(iConfiguration.field("class"));
        }
        if (iConfiguration.containsField("skipDuplicates")) {
            this.skipDuplicates = (Boolean)this.resolve(iConfiguration.field("skipDuplicates"));
        }
    }

    @Override
    public void begin() {
        OrientVertexType cls;
        if (this.vertexClass != null && (cls = this.pipeline.getGraphDatabase().getVertexType(this.vertexClass)) == null) {
            this.pipeline.getGraphDatabase().createVertexType(this.vertexClass);
        }
    }

    @Override
    public String getName() {
        return "vertex";
    }

    @Override
    public Object executeTransform(Object input) {
        OrientVertex v = this.pipeline.getGraphDatabase().getVertex(input);
        if (v == null) {
            return null;
        }
        if (this.vertexClass != null && !this.vertexClass.equals(v.getRecord().getClassName())) {
            try {
                v.setProperty("@class", (Object)this.vertexClass);
            }
            catch (ORecordDuplicatedException e) {
                if (this.skipDuplicates) {
                    return null;
                }
                throw e;
            }
        }
        return v;
    }
}

