/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.nio.ByteOrder;

public class OLongSerializer
implements OBinarySerializer<Long> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static OLongSerializer INSTANCE = new OLongSerializer();
    public static final byte ID = 10;
    public static final int LONG_SIZE = 8;

    @Override
    public int getObjectSize(Long object) {
        return 8;
    }

    @Override
    public void serialize(Long object, byte[] stream, int startPosition) {
        long value = object;
        stream[startPosition] = (byte)(value >>> 56 & 0xFFL);
        stream[startPosition + 1] = (byte)(value >>> 48 & 0xFFL);
        stream[startPosition + 2] = (byte)(value >>> 40 & 0xFFL);
        stream[startPosition + 3] = (byte)(value >>> 32 & 0xFFL);
        stream[startPosition + 4] = (byte)(value >>> 24 & 0xFFL);
        stream[startPosition + 5] = (byte)(value >>> 16 & 0xFFL);
        stream[startPosition + 6] = (byte)(value >>> 8 & 0xFFL);
        stream[startPosition + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    @Override
    public Long deserialize(byte[] stream, int startPosition) {
        return (long)(0xFF & stream[startPosition + 7] | (0xFF & stream[startPosition + 6]) << 8 | (0xFF & stream[startPosition + 5]) << 16) | (long)(0xFF & stream[startPosition + 4]) << 24 | (long)(0xFF & stream[startPosition + 3]) << 32 | (long)(0xFF & stream[startPosition + 2]) << 40 | (long)(0xFF & stream[startPosition + 1]) << 48 | (long)(0xFF & stream[startPosition]) << 56;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 10;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public void serializeNative(Long object, byte[] stream, int startPosition) {
        CONVERTER.putLong(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    @Override
    public Long deserializeNative(byte[] stream, int startPosition) {
        return CONVERTER.getLong(stream, startPosition, ByteOrder.nativeOrder());
    }

    @Override
    public void serializeInDirectMemory(Long object, ODirectMemory memory, long pointer) {
        memory.setLong(pointer, object);
    }

    @Override
    public Long deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        return memory.getLong(pointer);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return 8;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 8;
    }
}

