/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.ShardingDriverExtension;
import oracle.jdbc.driver.ShardingKeyInfo;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

@ProxyFor(value={OracleStatement.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingStatement
implements Diagnosable {
    private static final String CLASS_NAME = AbstractShardingStatement.class.getName();
    protected OracleResultSet.ResultSetType resultSetType;
    private String currentSQL;
    ConcurrentHashMap<String, SetterCallHistoryEntry> setterStmtMap = new ConcurrentHashMap();
    boolean closed;
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    int statementType = 0;
    boolean isCloseOnCompletion = false;
    AbstractShardingResultSet currentResultSet;
    static int NON_CACHED = 3;
    boolean lastStatementExecutionOnDirectShard = false;
    Vector<String> m_batchItems = null;
    protected CallHistoryEntry head;
    protected CallHistoryEntry tail;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract Statement getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Statement var1);

    void initialize(AbstractShardingConnection connection, OracleResultSet.ResultSetType resultSetType) {
        this.resultSetType = resultSetType;
        this.currentSQL = null;
        this.closed = false;
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={String.class}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preStmtExecuteQuery(Method m, Object receiver, Object ... args) {
        try {
            ((AbstractShardingConnection)this.getCreator()).acquireConnectionLock();
            this.ensureOpen();
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            this.closeDatabaseStatementWithSetterReplay();
            this.currentSQL = (String)args[0];
            OracleStatement databaseStatement = this.checkForKeyTokensAndGetUCPStatement(this.currentSQL);
            this.delegatesBeforeExecuteCalls(databaseStatement);
        }
        catch (SQLException ex) {
            this.currentSQL = null;
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
            throw new RuntimeException(ex);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={String.class})})
    protected ResultSet postStmtExecuteQuery(Method m, ResultSet result) {
        try {
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            result = this.createResultSetProxy(result);
            this.currentResultSet = (AbstractShardingResultSet)((Object)result);
            this.setShardingKeyRpnTokens(databaseStatement, this.currentSQL);
            this.makeDatabaseConnectionSticky((AbstractShardingConnection)this.getCreator(), (OracleConnection)databaseStatement.getConnection());
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.currentSQL = null;
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected Object postStmtExecuteUpdate(Method m, Object result) {
        try {
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            this.setShardingKeyRpnTokens(databaseStatement, this.currentSQL);
            this.makeDatabaseConnectionSticky((AbstractShardingConnection)this.getCreator(), (OracleConnection)databaseStatement.getConnection());
            Object object = result;
            return object;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.currentSQL = null;
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
    }

    @OnError(value=SQLException.class)
    protected Object onErrorStmt(Method m, SQLException e) throws SQLException {
        this.currentSQL = null;
        ((AbstractShardingConnection)this.getCreator()).checkAndReleaseConnectionLock();
        throw e;
    }

    public void close() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.closeDatabaseStatementWithSetterReplay();
            this.purgeCallEntries();
            applicationConnection.removeStatement(this);
            this.closed = true;
        }
    }

    public void clearDefines() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.clearDefines();
            } else {
                Class[] argsType = new Class[]{};
                Object[] args = new Object[]{};
                CallHistoryEntry entry = new CallHistoryEntry("clearDefines", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int column_index, int type) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(column_index, type);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{column_index, type};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(ccolumnIndex, type, lobPrefetchSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int ccolumnIndex, int typeCode, String typeName) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(ccolumnIndex, typeCode, typeName);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
                Object[] args = new Object[]{ccolumnIndex, typeCode, typeName};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnType(int ccolumnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnType(ccolumnIndex, type, lobPrefetchSize, formOfUse);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize, formOfUse};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnTypeBytes(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnTypeBytes(ccolumnIndex, type, lobPrefetchSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnTypeBytes", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineColumnTypeChars(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.defineColumnTypeChars(ccolumnIndex, type, lobPrefetchSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{ccolumnIndex, type, lobPrefetchSize};
                CallHistoryEntry entry = new CallHistoryEntry("defineColumnTypeChars", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.setDatabaseChangeRegistration(registration);
            } else {
                Class[] argsType = new Class[]{DatabaseChangeRegistration.class};
                Object[] args = new Object[]{registration};
                CallHistoryEntry entry = new CallHistoryEntry("setDatabaseChangeRegistration", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void setSnapshotSCN(long scn) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.setSnapshotSCN(scn);
            } else {
                Class[] argsType = new Class[]{Long.TYPE};
                Object[] args = new Object[]{scn};
                CallHistoryEntry entry = new CallHistoryEntry("setSnapshotSCN", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void registerBindChecksumListener(OracleStatement.BindChecksumListener listener) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.registerBindChecksumListener(listener);
            } else {
                Class[] argsType = new Class[]{OracleStatement.BindChecksumListener.class};
                Object[] args = new Object[]{listener};
                CallHistoryEntry entry = new CallHistoryEntry("registerBindChecksumListener", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.setEscapeProcessing(enable);
            } else {
                Class[] argsType = new Class[]{Boolean.TYPE};
                Object[] args = new Object[]{enable};
                CallHistoryEntry entry = new CallHistoryEntry("setEscapeProcessing", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.clearWarnings();
            } else {
                Class[] argsType = new Class[]{};
                Object[] args = new Object[]{};
                CallHistoryEntry entry = new CallHistoryEntry("clearWarnings", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowPrefetch(int value) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setRowPrefetch";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{value};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setRowPrefetch(value);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getRowPrefetch();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("RowPrefetch", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getRowPrefetch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLobPrefetchSize(int value) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setLobPrefetchSize";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{value};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setLobPrefetchSize(value);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getLobPrefetchSize();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("LobPrefetchSize", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getLobPrefetchSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int direction) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setFetchDirection";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{direction};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setFetchDirection(direction);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getFetchDirection();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("FetchDirection", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getFetchDirection() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int rows) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setFetchSize";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{rows};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setFetchSize(rows);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getFetchSize();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("FetchSize", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getFetchSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryTimeout(int max) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setQueryTimeout";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{max};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setQueryTimeout(max);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getQueryTimeout();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("QueryTimeout", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getQueryTimeout() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int max) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setMaxRows";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{max};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setMaxRows(max);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getMaxRows();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("MaxRows", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getMaxRows() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int max) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setMaxFieldSize";
                        Class[] argsType = new Class[]{Integer.TYPE};
                        Object[] args = new Object[]{max};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setMaxFieldSize(max);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Integer originalVal = databaseStatement.getMaxFieldSize();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("MaxFieldSize", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public int getMaxFieldSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedString(boolean fixedString) throws SQLException {
        block13: {
            OracleConnection databaseConnection;
            AbstractShardingConnection applicationConnection;
            block14: {
                applicationConnection = (AbstractShardingConnection)this.getCreator();
                databaseConnection = null;
                Statement databaseStatement = null;
                boolean newStatement = true;
                try {
                    try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                        String methodName = "setFixedString";
                        Class[] argsType = new Class[]{Boolean.TYPE};
                        Object[] args = new Object[]{fixedString};
                        databaseStatement = (OracleStatement)this.getDelegate();
                        if (databaseStatement != null) {
                            newStatement = false;
                            databaseStatement.setFixedString(fixedString);
                        } else {
                            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                            databaseStatement = this.createDatabaseStatement(databaseConnection);
                            Boolean originalVal = databaseStatement.getFixedString();
                            SetterCallHistoryEntry entry = new SetterCallHistoryEntry(originalVal, methodName, argsType, args);
                            this.setterStmtMap.put("FixedString", entry);
                        }
                    }
                    if (!newStatement) break block13;
                    if (databaseStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (newStatement) {
                        if (databaseStatement != null) {
                            databaseStatement.close();
                        }
                        applicationConnection.closeDatabaseConnection(databaseConnection);
                    }
                    throw throwable;
                }
                databaseStatement.close();
            }
            applicationConnection.closeDatabaseConnection(databaseConnection);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean getFixedString() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closeWithKey(String key) throws SQLException {
    }

    public int getcacheState() {
        return NON_CACHED;
    }

    public boolean isPoolable() throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        return false;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="setShardingKeyRpnTokens", args={byte[].class}), @Signature(name="getShardingKeyRpnTokens", args={}), @Signature(name="setCursorName", args={String.class}), @Signature(name="getserverCursor", args={})})
    protected void preUnsupportedStatementMethods(Method m, Object receiver, Object ... args) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public Connection getConnection() throws SQLException {
        return (Connection)this.getCreator();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet result;
        block9: {
            result = null;
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
                if (databaseStatement != null) {
                    result = databaseStatement.getGeneratedKeys();
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                        if (this.currentResultSet == null) {
                            this.currentResultSet = (AbstractShardingResultSet)((Object)result);
                        }
                    }
                    break block9;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet result;
        block8: {
            result = null;
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
                if (databaseStatement != null) {
                    result = databaseStatement.getResultSet();
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                        this.currentResultSet = (AbstractShardingResultSet)((Object)result);
                    }
                    break block8;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    public boolean getMoreResults() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.getMoreResults();
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.getMoreResults(current);
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean isNCHAR(int columnIndex) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                boolean bl = databaseStatement.isNCHAR(columnIndex);
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public String[] getRegisteredTableNames() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                String[] stringArray = databaseStatement.getRegisteredTableNames();
                return stringArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getRegisteredQueryId() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l = databaseStatement.getRegisteredQueryId();
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public int getUpdateCount() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                int n = databaseStatement.getUpdateCount();
                return n;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getQueryId() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l = databaseStatement.getQueryId();
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public byte[] getCompileKey() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                byte[] byArray = databaseStatement.getCompileKey();
                return byArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getChecksum() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                long l = databaseStatement.getChecksum();
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                OracleStatement.SqlKind sqlKind = databaseStatement.getSqlKind();
                return sqlKind;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                SQLWarning sQLWarning = databaseStatement.getWarnings();
                return sQLWarning;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return this.resultSetType.getConcur();
    }

    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return this.resultSetType.getType();
    }

    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return 1;
    }

    public int getstatementType() {
        return this.statementType;
    }

    public void cancel() throws SQLException {
        OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
        if (databaseStatement != null) {
            databaseStatement.cancel();
        }
    }

    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.isCloseOnCompletion = true;
    }

    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    public void addBatch(String sql) throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.ensureOpen();
            this.addBatchItem(sql);
        }
    }

    public void clearBatch() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement databaseStatement = (OracleStatement)this.getDelegate();
            if (databaseStatement != null) {
                databaseStatement.clearBatch();
            } else {
                this.clearBatchCritical();
            }
        }
    }

    public int[] executeBatch() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        OracleConnection databaseConnection = null;
        OracleStatement databaseStatement = null;
        try {
            Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();
            try {
                Object object;
                databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
                databaseStatement = this.createDatabaseStatement(databaseConnection);
                this.setDelegate(databaseStatement);
                if (this.m_batchItems != null) {
                    object = this.m_batchItems.iterator();
                    while (object.hasNext()) {
                        String sql = (String)object.next();
                        databaseStatement.addBatch(sql);
                    }
                }
                object = databaseStatement.executeBatch();
                if (lock != null) {
                    lock.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.clearBatchItems();
        }
    }

    void closeDatabaseStatement() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Statement databaseStatement = this.getDelegate();
        if (databaseStatement != null && !databaseStatement.isClosed()) {
            OracleConnection databaseConnection = (OracleConnection)databaseStatement.getConnection();
            databaseStatement.close();
            applicationConnection.closeDatabaseConnectionWithSetterReplay(databaseConnection, this.lastStatementExecutionOnDirectShard);
            this.setDelegate(null);
        }
    }

    void closeDatabaseStatementWithSetterReplay() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        Statement databaseStatement = this.getDelegate();
        if (databaseStatement != null && !databaseStatement.isClosed()) {
            OracleConnection databaseConnection = (OracleConnection)databaseStatement.getConnection();
            this.delegatesStmtSetterCalls((OracleStatement)databaseStatement, false);
            databaseStatement.close();
            applicationConnection.closeDatabaseConnectionWithSetterReplay(databaseConnection, this.lastStatementExecutionOnDirectShard);
            this.setDelegate(null);
        }
    }

    protected OracleConnection checkForKeyTokensAndGetUCPConnection(String sql) throws SQLException {
        OracleConnection databaseConnection = null;
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        if (applicationConnection.getStickyDatabaseConnection() != null) {
            databaseConnection = applicationConnection.getStickyDatabaseConnection();
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "checkForKeyTokensAndGetUCPConnection", "using sticky connection for sql={0}", (String)null, (Throwable)null, (Object)sql);
        } else if (!applicationConnection.allowSingleShardTransaction() && !applicationConnection.getAutoCommit() && applicationConnection.inTransaction()) {
            databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnectionWithSetterReplay();
            this.lastStatementExecutionOnDirectShard = false;
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "checkForKeyTokensAndGetUCPConnection", "allowSingleShardTxn=false autoCommit=false isInTxn=true, use CatalogConnection for sql={0}", (String)null, (Throwable)null, (Object)sql);
        } else {
            try {
                OracleShardingKey shardingKey = null;
                OracleShardingKey superShardingKey = null;
                OracleStatement.SqlKind sqlkind = OracleStatement.SqlKind.UNINITIALIZED;
                ShardingKeyInfo.KeyTokenInfo keyTokenInfo = ShardingKeyInfo.getKeyRpnTokens(sql, applicationConnection.gsmServiceName(), applicationConnection.userName(), applicationConnection.schemaName());
                if (keyTokenInfo != null) {
                    byte[] keyRpnTokens = keyTokenInfo.getKeyTokens();
                    sqlkind = keyTokenInfo.getSqlKind();
                    if (keyRpnTokens != null) {
                        OracleShardingKey[] shardingKeys = new ShardingKeyInfo().getShardingKeys((OracleStatement)((Object)this), keyRpnTokens, ((AbstractShardingConnection)this.getCreator()).getDbCharSet());
                        shardingKey = shardingKeys[0];
                        superShardingKey = shardingKeys[1];
                    }
                }
                if (shardingKey != null && (applicationConnection.getAutoCommit() || sqlkind == OracleStatement.SqlKind.SELECT || applicationConnection.allowSingleShardTransaction())) {
                    databaseConnection = (OracleConnection)applicationConnection.getShardConnectionWithSetterReplay(shardingKey, superShardingKey);
                    this.lastStatementExecutionOnDirectShard = true;
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "checkForKeyTokensAndGetUCPConnection", "using direct shard connection for sql={0}", (String)null, (Throwable)null, (Object)sql);
                } else {
                    databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnectionWithSetterReplay();
                    this.lastStatementExecutionOnDirectShard = false;
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "checkForKeyTokensAndGetUCPConnection", "using catalog connection for sql={0}", (String)null, (Throwable)null, (Object)sql);
                }
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
        }
        return databaseConnection;
    }

    private OracleStatement checkForKeyTokensAndGetUCPStatement(String sql) throws SQLException {
        OracleStatement databaseStatement = null;
        OracleConnection databaseConnection = this.checkForKeyTokensAndGetUCPConnection(sql);
        databaseStatement = this.createDatabaseStatement(databaseConnection);
        this.setDelegate(databaseStatement);
        return databaseStatement;
    }

    protected void setShardingKeyRpnTokens(OracleStatement databaseStatement, String sql) throws SQLException {
        byte[] shardingKeyRpnTokens = databaseStatement.getShardingKeyRpnTokens();
        if (shardingKeyRpnTokens != null) {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            ShardingKeyInfo.putKeyRpnTokens(sql, applicationConnection.gsmServiceName(), applicationConnection.userName(), applicationConnection.schemaName(), shardingKeyRpnTokens, databaseStatement.getSqlKind());
            databaseStatement.setShardingKeyRpnTokens(null);
        }
    }

    protected void makeDatabaseConnectionSticky(AbstractShardingConnection appConnection, OracleConnection databaseConnection) throws SQLException {
        appConnection.makeDatabaseConnectionSticky(databaseConnection);
    }

    protected ResultSet createResultSetProxy(ResultSet rs) throws SQLException {
        return ShardingDriverExtension.PROXY_FACTORY.proxyFor(rs, this);
    }

    protected OracleStatement createDatabaseStatement(OracleConnection databaseConnection) throws SQLException {
        return (OracleStatement)databaseConnection.createStatement(this.resultSetType.getType(), this.resultSetType.getConcur());
    }

    protected OracleStatement createDatabaseStatementWithReplay(OracleConnection databaseConnection) throws SQLException {
        OracleStatement databaseStatement = (OracleStatement)databaseConnection.createStatement(this.resultSetType.getType(), this.resultSetType.getConcur());
        if (databaseStatement != null) {
            this.delegatesStmtSetterCalls(databaseStatement, true);
        }
        return databaseStatement;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.getCreator();
    }

    final void ensureOpen() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        if (applicationConnection.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    void addBatchItem(String sql) {
        if (this.m_batchItems == null) {
            this.m_batchItems = new Vector();
        }
        this.m_batchItems.addElement(sql);
    }

    void clearBatchCritical() throws SQLException {
        this.ensureOpen();
        this.clearBatchItems();
    }

    void clearBatchItems() {
        if (this.m_batchItems != null) {
            this.m_batchItems.removeAllElements();
        }
    }

    protected void appendCallEntry(CallHistoryEntry entry) {
        entry.prevEntry = this.tail;
        entry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = entry;
        }
        this.tail = entry;
        if (this.head == null) {
            this.head = entry;
        }
    }

    protected void removeCallEntry(CallHistoryEntry entry) {
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
        }
        if (entry.prevEntry != null) {
            entry.prevEntry.nextEntry = entry.nextEntry;
        }
        if (this.head == entry) {
            this.head = entry.nextEntry;
        }
        if (this.tail == entry) {
            this.tail = entry.prevEntry;
        }
    }

    protected void purgeCallEntries() {
        this.head = null;
        this.tail = null;
        this.setterStmtMap = null;
    }

    void delegatesBeforeExecuteCalls(OracleStatement databaseStatement) throws SQLException {
        try {
            CallHistoryEntry entry = this.head;
            while (entry != this.tail) {
                Method m = databaseStatement.getClass().getMethod(entry.methodName, entry.argsType);
                m.invoke((Object)databaseStatement, entry.args);
                entry = entry.nextEntry;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SQLException(ex);
        }
    }

    void delegatesStmtSetterCalls(OracleStatement databaseStatement, boolean newVal) throws SQLException {
        try {
            for (SetterCallHistoryEntry entry : this.setterStmtMap.values()) {
                CallHistoryEntry callEntry = entry.callHistoryEnrty;
                Method m = databaseStatement.getClass().getMethod(callEntry.methodName, callEntry.argsType);
                if (newVal) {
                    m.invoke((Object)databaseStatement, callEntry.args);
                    continue;
                }
                m.invoke((Object)databaseStatement, entry.originalValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SQLException(ex);
        }
    }

    boolean closeByDependent(OracleConnection databaseConnection) throws SQLException {
        if (this.isCloseOnCompletion && (this.currentResultSet == null || this.currentResultSet.isComplete())) {
            Statement databaseStatement = this.getDelegate();
            if (databaseStatement != null && !databaseStatement.isClosed()) {
                this.close();
            } else {
                AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
                applicationConnection.closeDatabaseConnectionWithSetterReplay(databaseConnection, this.lastStatementExecutionOnDirectShard);
                this.setDelegate(null);
                this.purgeCallEntries();
                applicationConnection.removeStatement(this);
                this.closed = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    static class CallHistoryEntry {
        String methodName;
        Class<?>[] argsType;
        Object[] args;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;

        CallHistoryEntry(String methodName, Class<?>[] argsType, Object[] args) {
            this.methodName = methodName;
            this.argsType = argsType;
            this.args = args;
        }
    }

    static class SetterCallHistoryEntry {
        CallHistoryEntry callHistoryEnrty;
        Object originalValue;

        SetterCallHistoryEntry(Object originalValue, String methodName, Class<?>[] argsType, Object[] args) {
            this.originalValue = originalValue;
            this.callHistoryEnrty = new CallHistoryEntry(methodName, argsType, args);
        }
    }
}

