/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSCacheValue;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.FontFaceFontSupplier;
import com.openhtmltopdf.outputdevice.helper.FontFamily;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import com.openhtmltopdf.outputdevice.helper.MinimalFontDescription;
import com.openhtmltopdf.pdfboxout.PDFontSupplier;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxRawPDFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.util.XRLog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PdfBoxFontResolver
implements FontResolver {
    private Map<String, FontFamily<FontDescription>> _fontFamilies;
    private Map<String, FontDescription> _fontCache = new HashMap<String, FontDescription>();
    private final PDDocument _doc;
    private final SharedContext _sharedContext;
    private final List<TrueTypeCollection> _collectionsToClose = new ArrayList<TrueTypeCollection>();
    private final FSCacheEx<String, FSCacheValue> _fontMetricsCache;
    private final PdfRendererBuilder.PdfAConformance _pdfAConformance;
    private final boolean _pdfUaConform;

    public PdfBoxFontResolver(SharedContext sharedContext, PDDocument doc, FSCacheEx<String, FSCacheValue> pdfMetricsCache, PdfRendererBuilder.PdfAConformance pdfAConformance, boolean pdfUaConform) {
        this._sharedContext = sharedContext;
        this._doc = doc;
        this._fontMetricsCache = pdfMetricsCache;
        this._pdfAConformance = pdfAConformance;
        this._pdfUaConform = pdfUaConform;
        this._fontFamilies = this._pdfAConformance == PdfRendererBuilder.PdfAConformance.NONE && !pdfUaConform ? PdfBoxFontResolver.createInitialFontMap() : new HashMap();
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(renderingContext, spec.families, spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
    }

    public void close() {
        this._fontCache.clear();
        for (TrueTypeCollection collection : this._collectionsToClose) {
            try {
                collection.close();
            }
            catch (IOException iOException) {}
        }
        this._collectionsToClose.clear();
    }

    @Deprecated
    public void flushCache() {
        this._fontFamilies = PdfBoxFontResolver.createInitialFontMap();
        this.close();
        this._fontCache = new HashMap<String, FontDescription>();
    }

    @Deprecated
    public void flushFontFaceFonts() {
        this._fontCache = new HashMap<String, FontDescription>();
        Iterator<FontFamily<FontDescription>> i = this._fontFamilies.values().iterator();
        while (i.hasNext()) {
            FontFamily<FontDescription> family = i.next();
            Iterator j = family.getFontDescriptions().iterator();
            while (j.hasNext()) {
                FontDescription d = (FontDescription)j.next();
                if (!d.isFromFontFace()) continue;
                j.remove();
            }
            if (family.getFontDescriptions().size() != 0) continue;
            i.remove();
        }
    }

    public void importFontFaces(List<FontFaceRule> fontFaces) {
        for (FontFaceRule rule : fontFaces) {
            CalculatedStyle style = rule.getCalculatedStyle();
            FSDerivedValue src = style.valueByName(CSSName.SRC);
            if (src == IdentValue.NONE) continue;
            boolean noSubset = style.isIdent(CSSName.FS_FONT_SUBSET, IdentValue.COMPLETE_FONT);
            String fontFamily = null;
            IdentValue fontWeight = null;
            IdentValue fontStyle = null;
            if (!rule.hasFontFamily()) {
                XRLog.cssParse((Level)Level.WARNING, (String)"Must provide at least a font-family and src in @font-face rule");
                continue;
            }
            fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
            if (rule.hasFontWeight()) {
                fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
            }
            if (rule.hasFontStyle()) {
                fontStyle = style.getIdent(CSSName.FONT_STYLE);
            }
            this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), !noSubset);
        }
    }

    public void addFontDirectory(String dir, boolean embedded) throws IOException {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lower = name.toLowerCase(Locale.US);
                    return lower.endsWith(".ttf") || lower.endsWith(".ttc");
                }
            });
            assert (files != null);
            for (File file : files) {
                this.addFont(file, file.getName(), (Integer)400, IdentValue.NORMAL, embedded);
            }
        }
    }

    private void addFont(TrueTypeFont trueTypeFont, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        PDType0Font font = PDType0Font.load((PDDocument)this._doc, (TrueTypeFont)trueTypeFont, (boolean)subset);
        this.addFontLazy(new PDFontSupplier((PDFont)font), fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    private void addFontLazy(FSSupplier<PDFont> font, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        FontFamily<FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        FontDescription descr = new FontDescription(this._doc, font, this.normalizeFontStyle(fontStyleOverride), this.normalizeFontWeight(fontWeightOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        if (!subset) {
            if (descr.realizeFont()) {
                fontFamily.addFontDescription((MinimalFontDescription)descr);
            }
        } else {
            fontFamily.addFontDescription((MinimalFontDescription)descr);
        }
    }

    private void addFontCollection(TrueTypeCollection collection, final String fontFamilyNameOverride, final Integer fontWeightOverride, final IdentValue fontStyleOverride, final boolean subset) throws IOException {
        collection.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

            public void process(TrueTypeFont ttf) throws IOException {
                PdfBoxFontResolver.this.addFont(ttf, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
            }
        });
        this._collectionsToClose.add(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFontCollection(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        try (InputStream inputStream = (InputStream)supplier.supply();){
            TrueTypeCollection collection = new TrueTypeCollection(inputStream);
            this.addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
        }
    }

    public void addFontCollection(File file, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        TrueTypeCollection collection = new TrueTypeCollection(file);
        this.addFontCollection(collection, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    public void addFont(File fontFile, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        if (fontFile.getName().toLowerCase(Locale.US).endsWith(".ttc")) {
            this.addFontCollection(fontFile, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
            return;
        }
        this.addFontLazy(new FilePDFontSupplier(fontFile, this._doc), fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    public void addFont(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        FontFamily<FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        FontDescription descr = new FontDescription(this._doc, supplier, this.normalizeFontWeight(fontWeightOverride), this.normalizeFontStyle(fontStyleOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        if (!subset) {
            if (descr.realizeFont()) {
                fontFamily.addFontDescription((MinimalFontDescription)descr);
            }
        } else {
            fontFamily.addFontDescription((MinimalFontDescription)descr);
        }
    }

    public void addFont(PDFontSupplier supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        FontFamily<FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        FontDescription descr = new FontDescription(this._doc, (FSSupplier)supplier, this.normalizeFontStyle(fontStyleOverride), this.normalizeFontWeight(fontWeightOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        if (!subset) {
            if (descr.realizeFont()) {
                fontFamily.addFontDescription((MinimalFontDescription)descr);
            }
        } else {
            fontFamily.addFontDescription((MinimalFontDescription)descr);
        }
    }

    private int normalizeFontWeight(IdentValue fontWeight) {
        return fontWeight != null ? FontResolverHelper.convertWeightToInt((IdentValue)fontWeight) : 400;
    }

    private int normalizeFontWeight(Integer fontWeight) {
        return fontWeight != null ? fontWeight : 400;
    }

    private IdentValue normalizeFontStyle(IdentValue fontStyle) {
        return fontStyle != null ? fontStyle : IdentValue.NORMAL;
    }

    private void addFontFaceFont(String fontFamilyName, IdentValue fontWeight, IdentValue fontStyle, String uri, boolean subset) {
        FontFaceFontSupplier fontSupplier = new FontFaceFontSupplier(this._sharedContext, uri);
        FontFamily<FontDescription> fontFamily = this.getFontFamily(fontFamilyName);
        FontDescription description = new FontDescription(this._doc, (FSSupplier)fontSupplier, this.normalizeFontWeight(fontWeight), this.normalizeFontStyle(fontStyle), fontFamilyName, true, subset, this._fontMetricsCache);
        if (!subset) {
            if (description.realizeFont()) {
                fontFamily.addFontDescription((MinimalFontDescription)description);
            }
        } else {
            fontFamily.addFontDescription((MinimalFontDescription)description);
        }
    }

    private FontFamily<FontDescription> getFontFamily(String fontFamilyName) {
        FontFamily fontFamily = this._fontFamilies.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            this._fontFamilies.put(fontFamilyName, (FontFamily<FontDescription>)fontFamily);
        }
        return fontFamily;
    }

    private FSFont resolveFont(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        ArrayList<FontDescription> fonts = new ArrayList<FontDescription>(3);
        if (families != null) {
            for (int i = 0; i < families.length; ++i) {
                FontDescription font = this.resolveFont(ctx, families[i], size, weight, style, variant);
                if (font == null) continue;
                fonts.add(font);
            }
        }
        if (this._pdfAConformance == PdfRendererBuilder.PdfAConformance.NONE && !this._pdfUaConform) {
            fonts.add(this.resolveFont(ctx, "Serif", size, weight, style, variant));
        }
        return new PdfBoxFSFont(fonts, size);
    }

    private String normalizeFontFamily(String fontFamily) {
        String result = fontFamily;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.equalsIgnoreCase("serif")) {
            result = "Serif";
        } else if (result.equalsIgnoreCase("sans-serif")) {
            result = "SansSerif";
        } else if (result.equalsIgnoreCase("monospace")) {
            result = "Monospaced";
        }
        return result;
    }

    private FontDescription resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String normalizedFontFamily = this.normalizeFontFamily(fontFamily);
        String cacheKey = PdfBoxFontResolver.getHashName(normalizedFontFamily, weight, style);
        FontDescription result = this._fontCache.get(cacheKey);
        if (result != null) {
            return result;
        }
        FontFamily<FontDescription> family = this._fontFamilies.get(normalizedFontFamily);
        if (family != null && (result = (FontDescription)family.match(FontResolverHelper.convertWeightToInt((IdentValue)weight), style)) != null) {
            this._fontCache.put(cacheKey, result);
            return result;
        }
        return null;
    }

    protected static String getHashName(String name, IdentValue weight, IdentValue style) {
        return name + "-" + weight + "-" + style;
    }

    private static Map<String, FontFamily<FontDescription>> createInitialFontMap() {
        HashMap<String, FontFamily<FontDescription>> result = new HashMap<String, FontFamily<FontDescription>>();
        try {
            PdfBoxFontResolver.addCourier(result);
            PdfBoxFontResolver.addTimes(result);
            PdfBoxFontResolver.addHelvetica(result);
            PdfBoxFontResolver.addSymbol(result);
            PdfBoxFontResolver.addZapfDingbats(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    private static PDFont createFont(PDFont font) throws IOException {
        return font;
    }

    private static void addCourier(HashMap<String, FontFamily<FontDescription>> result) throws IOException {
        FontFamily courier = new FontFamily();
        courier.setName("Courier");
        courier.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
        courier.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER_OBLIQUE), IdentValue.OBLIQUE, 400));
        courier.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER_BOLD), IdentValue.NORMAL, 700));
        courier.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.COURIER), IdentValue.NORMAL, 400));
        result.put("DialogInput", (FontFamily<FontDescription>)courier);
        result.put("Monospaced", (FontFamily<FontDescription>)courier);
        result.put("Courier", (FontFamily<FontDescription>)courier);
    }

    private static void addTimes(HashMap<String, FontFamily<FontDescription>> result) throws IOException {
        FontFamily times = new FontFamily();
        times.setName("Times");
        times.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_BOLD_ITALIC), IdentValue.ITALIC, 700));
        times.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_ITALIC), IdentValue.ITALIC, 400));
        times.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_BOLD), IdentValue.NORMAL, 700));
        times.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.TIMES_ROMAN), IdentValue.NORMAL, 400));
        result.put("Serif", (FontFamily<FontDescription>)times);
        result.put("TimesRoman", (FontFamily<FontDescription>)times);
    }

    private static void addHelvetica(HashMap<String, FontFamily<FontDescription>> result) throws IOException {
        FontFamily helvetica = new FontFamily();
        helvetica.setName("Helvetica");
        helvetica.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
        helvetica.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA_OBLIQUE), IdentValue.OBLIQUE, 400));
        helvetica.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA_BOLD), IdentValue.NORMAL, 700));
        helvetica.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.HELVETICA), IdentValue.NORMAL, 400));
        result.put("Dialog", (FontFamily<FontDescription>)helvetica);
        result.put("SansSerif", (FontFamily<FontDescription>)helvetica);
        result.put("Helvetica", (FontFamily<FontDescription>)helvetica);
    }

    private static void addSymbol(Map<String, FontFamily<FontDescription>> result) throws IOException {
        FontFamily fontFamily = new FontFamily();
        fontFamily.setName("Symbol");
        fontFamily.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.SYMBOL), IdentValue.NORMAL, 400));
        result.put("Symbol", (FontFamily<FontDescription>)fontFamily);
    }

    private static void addZapfDingbats(Map<String, FontFamily<FontDescription>> result) throws IOException {
        FontFamily fontFamily = new FontFamily();
        fontFamily.setName("ZapfDingbats");
        fontFamily.addFontDescription((MinimalFontDescription)new FontDescription(PdfBoxFontResolver.createFont((PDFont)PDType1Font.ZAPF_DINGBATS), IdentValue.NORMAL, 400));
        result.put("ZapfDingbats", (FontFamily<FontDescription>)fontFamily);
    }

    public static class FontDescription
    implements MinimalFontDescription {
        private final IdentValue _style;
        private final int _weight;
        private final String _family;
        private final PDDocument _doc;
        private FSSupplier<InputStream> _supplier;
        private FSSupplier<PDFont> _fontSupplier;
        private PDFont _font;
        private final boolean _isFromFontFace;
        private final boolean _isSubset;
        private PdfBoxRawPDFontMetrics _metrics;
        private final FSCacheEx<String, FSCacheValue> _metricsCache;

        private FontDescription(PDFont font, IdentValue style, int weight) {
            this(null, font, style, weight);
        }

        private FontDescription(PDDocument doc, FSSupplier<InputStream> supplier, int weight, IdentValue style, String family, boolean isFromFontFace, boolean isSubset, FSCacheEx<String, FSCacheValue> metricsCache) {
            this._supplier = supplier;
            this._weight = weight;
            this._style = style;
            this._doc = doc;
            this._family = family;
            this._isFromFontFace = isFromFontFace;
            this._isSubset = isSubset;
            this._metricsCache = metricsCache;
            this._metrics = this.getFontMetricsFromCache(family, weight, style);
        }

        private FontDescription(PDDocument doc, PDFont font, IdentValue style, int weight) {
            this._font = font;
            this._style = style;
            this._weight = weight;
            this._supplier = null;
            this._doc = doc;
            this._metricsCache = null;
            this._family = null;
            this._isFromFontFace = false;
            this._isSubset = false;
            PDFontDescriptor descriptor = font.getFontDescriptor();
            try {
                this._metrics = PdfBoxRawPDFontMetrics.fromPdfBox(font, descriptor);
            }
            catch (IOException e) {
                XRLog.exception((String)"Couldn't load font metrics.", (Throwable)e);
            }
        }

        private FontDescription(PDDocument doc, FSSupplier<PDFont> fontSupplier, IdentValue style, int weight, String family, boolean isFromFontFace, boolean isSubset, FSCacheEx<String, FSCacheValue> metricsCache) {
            this._fontSupplier = fontSupplier;
            this._style = style;
            this._weight = weight;
            this._supplier = null;
            this._doc = doc;
            this._family = family;
            this._isFromFontFace = isFromFontFace;
            this._isSubset = isSubset;
            this._metricsCache = metricsCache;
            this._metrics = this.getFontMetricsFromCache(family, weight, style);
        }

        private String createFontMetricsCacheKey(String family, int weight, IdentValue style) {
            return "font-metrics:" + family + ":" + weight + ":" + style.toString();
        }

        private PdfBoxRawPDFontMetrics getFontMetricsFromCache(String family, int weight, IdentValue style) {
            return (PdfBoxRawPDFontMetrics)this._metricsCache.get((Object)this.createFontMetricsCacheKey(family, weight, style));
        }

        private void putFontMetricsInCache(String family, int weight, IdentValue style, PdfBoxRawPDFontMetrics metrics) {
            this._metricsCache.put((Object)this.createFontMetricsCacheKey(family, weight, style), (Object)metrics);
        }

        private boolean loadMetrics() {
            try {
                PDFontDescriptor descriptor = this._font.getFontDescriptor();
                this._metrics = PdfBoxRawPDFontMetrics.fromPdfBox(this._font, descriptor);
                this.putFontMetricsInCache(this._family, this._weight, this._style, this._metrics);
                return true;
            }
            catch (IOException e) {
                XRLog.exception((String)"Couldn't load font. Please check that it is a valid truetype font.");
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean realizeFont() {
            if (this._font == null && this._fontSupplier != null) {
                XRLog.load((Level)Level.INFO, (String)("Loading font(" + this._family + ") from PDFont supplier now."));
                this._font = (PDFont)this._fontSupplier.supply();
                this._fontSupplier = null;
                if (!this.isMetricsAvailable()) {
                    return this.loadMetrics();
                }
            }
            if (this._font == null && this._supplier != null) {
                XRLog.load((Level)Level.INFO, (String)("Loading font(" + this._family + ") from InputStream supplier now."));
                InputStream is = (InputStream)this._supplier.supply();
                this._supplier = null;
                if (is == null) {
                    return false;
                }
                try {
                    this._font = PDType0Font.load((PDDocument)this._doc, (InputStream)is, (boolean)this._isSubset);
                    if (!this.isMetricsAvailable()) {
                        boolean bl = this.loadMetrics();
                        return bl;
                    }
                }
                catch (IOException e) {
                    XRLog.exception((String)"Couldn't load font. Please check that it is a valid truetype font.");
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return this._font != null;
        }

        public boolean isFontAvailable() {
            return this._font != null;
        }

        public PDFont getFont() {
            this.realizeFont();
            return this._font;
        }

        public int getWeight() {
            return this._weight;
        }

        public IdentValue getStyle() {
            return this._style;
        }

        public boolean isFromFontFace() {
            return this._isFromFontFace;
        }

        public boolean isMetricsAvailable() {
            return this._metrics != null;
        }

        public PdfBoxRawPDFontMetrics getFontMetrics() {
            if (!this.isMetricsAvailable()) {
                this.realizeFont();
            }
            return this._metrics;
        }
    }

    private static class FilePDFontSupplier
    implements FSSupplier<PDFont> {
        private final File _fontFile;
        private final PDDocument _doc;

        FilePDFontSupplier(File fontFile, PDDocument doc) {
            this._fontFile = fontFile;
            this._doc = doc;
        }

        public PDFont supply() {
            try {
                return PDType0Font.load((PDDocument)this._doc, (File)this._fontFile);
            }
            catch (IOException e) {
                XRLog.exception((String)("Couldn't load font (" + this._fontFile.getAbsolutePath() + "). Please check that it is a valid truetype font."), (Throwable)e);
                return null;
            }
        }
    }
}

