/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.WriteAheadEntry;
import com.netflix.astyanax.WriteAheadLog;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.NoAvailableHostsException;
import com.netflix.astyanax.connectionpool.exceptions.WalException;
import com.netflix.astyanax.impl.NoOpWriteAheadLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WriteAheadMutationBatchExecutor {
    private ListeningExecutorService executor;
    private WriteAheadLog wal = new NoOpWriteAheadLog();
    private Predicate<Exception> retryablePredicate = Predicates.alwaysFalse();
    private final Keyspace keyspace;
    private long waitOnNoHosts = 1000L;

    public WriteAheadMutationBatchExecutor(Keyspace keyspace, int nThreads) {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(nThreads, new ThreadFactoryBuilder().setDaemon(true).build()));
        this.keyspace = keyspace;
    }

    public WriteAheadMutationBatchExecutor(Keyspace keyspace, ExecutorService executor) {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.keyspace = keyspace;
    }

    public WriteAheadMutationBatchExecutor usingWriteAheadLog(WriteAheadLog wal) {
        this.wal = wal;
        return this;
    }

    public WriteAheadMutationBatchExecutor usingRetryablePredicate(Predicate<Exception> predicate) {
        this.retryablePredicate = predicate;
        return this;
    }

    public List<ListenableFuture<OperationResult<Void>>> replayWal(int count) {
        WriteAheadEntry walEntry;
        ArrayList futures = Lists.newArrayList();
        while (null != (walEntry = this.wal.readNextEntry()) && count-- > 0) {
            MutationBatch m = this.keyspace.prepareMutationBatch();
            try {
                walEntry.readMutation(m);
                futures.add(this.executeWalEntry(walEntry, m));
            }
            catch (WalException e) {
                this.wal.removeEntry(walEntry);
            }
        }
        return futures;
    }

    public ListenableFuture<OperationResult<Void>> execute(MutationBatch m) throws WalException {
        WriteAheadEntry walEntry = this.wal.createEntry();
        walEntry.writeMutation(m);
        return this.executeWalEntry(walEntry, m);
    }

    private ListenableFuture<OperationResult<Void>> executeWalEntry(final WriteAheadEntry walEntry, final MutationBatch m) {
        return this.executor.submit((Callable)new Callable<OperationResult<Void>>(){

            @Override
            public OperationResult<Void> call() throws Exception {
                try {
                    OperationResult result = m.execute();
                    WriteAheadMutationBatchExecutor.this.wal.removeEntry(walEntry);
                    return result;
                }
                catch (Exception e) {
                    if (e instanceof NoAvailableHostsException) {
                        Thread.sleep(WriteAheadMutationBatchExecutor.this.waitOnNoHosts);
                    }
                    if (WriteAheadMutationBatchExecutor.this.retryablePredicate.apply((Object)e)) {
                        WriteAheadMutationBatchExecutor.this.executor.submit((Callable)this);
                    } else {
                        WriteAheadMutationBatchExecutor.this.wal.removeEntry(walEntry);
                    }
                    throw e;
                }
            }
        });
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

