/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;

public class FileUtils {
    public static final int NONE = 0;
    public static final int RECURSIVE = 1;
    public static final int RETRY = 2;
    public static final int SKIP_MISSING = 4;

    public static void delete(File f) throws IOException {
        FileUtils.delete(f, 0);
    }

    public static void delete(File f, int options) throws IOException {
        File[] items;
        if ((options & 4) != 0 && !f.exists()) {
            return;
        }
        if ((options & 1) != 0 && f.isDirectory() && (items = f.listFiles()) != null) {
            for (File c : items) {
                FileUtils.delete(c, options);
            }
        }
        if (!f.delete()) {
            if ((options & 2) != 0 && f.exists()) {
                for (int i = 1; i < 10; ++i) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!f.delete()) continue;
                    return;
                }
            }
            throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f.getAbsolutePath()));
        }
    }
}

