/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.Base64;

abstract class HttpAuthMethod {
    static final HttpAuthMethod NONE = new None();

    HttpAuthMethod() {
    }

    static HttpAuthMethod scanResponse(HttpURLConnection conn) {
        String hdr = conn.getHeaderField("WWW-Authenticate");
        if (hdr == null || hdr.length() == 0) {
            return NONE;
        }
        int sp = hdr.indexOf(32);
        if (sp < 0) {
            return NONE;
        }
        String type = hdr.substring(0, sp);
        if ("Basic".equalsIgnoreCase(type)) {
            return new Basic();
        }
        if ("Digest".equalsIgnoreCase(type)) {
            return new Digest(hdr.substring(sp + 1));
        }
        return NONE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean authorize(URIish uri, CredentialsProvider credentialsProvider) {
        String password;
        String username;
        if (credentialsProvider != null) {
            CredentialItem.Username u = new CredentialItem.Username();
            CredentialItem.Password p = new CredentialItem.Password();
            if (!credentialsProvider.supports(u, p) || !credentialsProvider.get(uri, u, p)) return false;
            username = u.getValue();
            password = new String(p.getValue());
            p.clear();
        } else {
            username = uri.getUser();
            password = uri.getPass();
        }
        if (username == null) return false;
        this.authorize(username, password);
        return true;
    }

    abstract void authorize(String var1, String var2);

    abstract void configureRequest(HttpURLConnection var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Digest
    extends HttpAuthMethod {
        static final String NAME = "Digest";
        private static final Random PRNG = new Random();
        private final Map<String, String> params;
        private int requestCount;
        private String user;
        private String pass;
        private static final char[] LHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        Digest(String hdr) {
            this.params = Digest.parse(hdr);
            String qop = this.params.get("qop");
            if ("auth".equals(qop)) {
                byte[] bin = new byte[8];
                PRNG.nextBytes(bin);
                this.params.put("cnonce", Base64.encodeBytes(bin));
            }
        }

        @Override
        void authorize(String username, String password) {
            this.user = username;
            this.pass = password;
        }

        @Override
        void configureRequest(HttpURLConnection conn) throws IOException {
            String expect;
            HashMap<String, String> p = new HashMap<String, String>(this.params);
            p.put("username", this.user);
            String realm = (String)p.get("realm");
            String nonce = (String)p.get("nonce");
            String uri = (String)p.get("uri");
            String qop = (String)p.get("qop");
            String method = conn.getRequestMethod();
            String A1 = this.user + ":" + realm + ":" + this.pass;
            String A2 = method + ":" + uri;
            if ("auth".equals(qop)) {
                String c = (String)p.get("cnonce");
                String nc = String.format("%08x", ++this.requestCount);
                p.put("nc", nc);
                expect = Digest.KD(Digest.H(A1), nonce + ":" + nc + ":" + c + ":" + qop + ":" + Digest.H(A2));
            } else {
                expect = Digest.KD(Digest.H(A1), nonce + ":" + Digest.H(A2));
            }
            p.put("response", expect);
            StringBuilder v = new StringBuilder();
            for (Map.Entry e : p.entrySet()) {
                if (v.length() > 0) {
                    v.append(", ");
                }
                v.append((String)e.getKey());
                v.append('=');
                v.append('\"');
                v.append((String)e.getValue());
                v.append('\"');
            }
            conn.setRequestProperty("Authorization", "Digest " + v);
        }

        private static String H(String data) {
            try {
                MessageDigest md = Digest.newMD5();
                md.update(data.getBytes("UTF-8"));
                return Digest.LHEX(md.digest());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not available", e);
            }
        }

        private static String KD(String secret, String data) {
            try {
                MessageDigest md = Digest.newMD5();
                md.update(secret.getBytes("UTF-8"));
                md.update((byte)58);
                md.update(data.getBytes("UTF-8"));
                return Digest.LHEX(md.digest());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not available", e);
            }
        }

        private static MessageDigest newMD5() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("No MD5 available", e);
            }
        }

        private static String LHEX(byte[] bin) {
            StringBuilder r = new StringBuilder(bin.length * 2);
            for (int i = 0; i < bin.length; ++i) {
                byte b = bin[i];
                r.append(LHEX[b >>> 4 & 0xF]);
                r.append(LHEX[b & 0xF]);
            }
            return r.toString();
        }

        private static Map<String, String> parse(String auth) {
            HashMap<String, String> p = new HashMap<String, String>();
            int next = 0;
            while (next < auth.length()) {
                String value;
                if (next < auth.length() && auth.charAt(next) == ',') {
                    ++next;
                }
                while (next < auth.length() && Character.isWhitespace(auth.charAt(next))) {
                    ++next;
                }
                int eq = auth.indexOf(61, next);
                if (eq < 0 || eq + 1 == auth.length()) {
                    return Collections.emptyMap();
                }
                String name = auth.substring(next, eq);
                if (auth.charAt(eq + 1) == '\"') {
                    int dq = auth.indexOf(34, eq + 2);
                    if (dq < 0) {
                        return Collections.emptyMap();
                    }
                    value = auth.substring(eq + 2, dq);
                    next = dq + 1;
                } else {
                    int space = auth.indexOf(32, eq + 1);
                    int comma = auth.indexOf(44, eq + 1);
                    if (space < 0) {
                        space = auth.length();
                    }
                    if (comma < 0) {
                        comma = auth.length();
                    }
                    int e = Math.min(space, comma);
                    value = auth.substring(eq + 1, e);
                    next = e + 1;
                }
                p.put(name, value);
            }
            return p;
        }
    }

    private static class Basic
    extends HttpAuthMethod {
        static final String NAME = "Basic";
        private String user;
        private String pass;

        private Basic() {
        }

        void authorize(String username, String password) {
            this.user = username;
            this.pass = password;
        }

        void configureRequest(HttpURLConnection conn) throws IOException {
            String ident = this.user + ":" + this.pass;
            String enc = Base64.encodeBytes(ident.getBytes("UTF-8"));
            conn.setRequestProperty("Authorization", "Basic " + enc);
        }
    }

    private static class None
    extends HttpAuthMethod {
        private None() {
        }

        void authorize(String user, String pass) {
        }

        void configureRequest(HttpURLConnection conn) throws IOException {
        }
    }
}

